/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.property.providers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

@Deprecated
public class CombinedPropertyProvider implements IPropertyProvider {

    private Map<Resource[], IPropertyProvider> providerMap = new HashMap<Resource[], IPropertyProvider>();

    public void addProvider(ReadGraph graph, IPropertyProvider provider) {
        for (Resource[] key : provider.provides(graph))
            providerMap.put(key, provider);
    }

    @Override
    public Object get(ReadGraph graph, final Resource resource, Resource... relations) throws DatabaseException {
        IPropertyProvider provider = providerMap.get(relations);
        if (provider == null)
            return null;
        return provider.get(graph, resource, relations);
    }

    @Override
    public Collection<Resource[]> provides(ReadGraph graph) {
        return providerMap.keySet();
    }

    @Override
    public void set(WriteGraph graph, Object value, Resource resource, Resource... relations) throws DatabaseException {
        IPropertyProvider provider = providerMap.get(relations);
        if (provider == null)
            throw new DoesNotHaveProperty();
        provider.set(graph, value, resource, relations);
    }

}
