/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.predicates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class Disjunction extends UnaryPredicate {

	Collection<IUnaryPredicate> predicates;

	public Disjunction(Collection<IUnaryPredicate> predicates) {
		this.predicates = predicates;
	}
	
	public Disjunction(IUnaryPredicate ... predicates) {
	    this(Arrays.asList(predicates));
	}

	@Override
	public Collection<Resource> getResources(ReadGraph g) throws DatabaseException {
		Iterator<IUnaryPredicate> it = predicates.iterator();
		
		while(it.hasNext()) {
			Collection<Resource> result = it.next().getResources(g);
			if(!result.isEmpty()) {
				while(it.hasNext()) {
					Collection<Resource> temp = it.next().getResources(g);
					if(!temp.isEmpty()) {
						Set<Resource> merged = new HashSet<Resource>(result.size() + temp.size());
						merged.addAll(result);
						merged.addAll(temp);
						while(it.hasNext())
							merged.addAll(it.next().getResources(g));
						return merged;
					}
				}
				return result;
			}
		}
		return Collections.emptyList();
	}
    
	@Override
	public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
		for(IUnaryPredicate pred : predicates)
			if(pred.has(g, resource))
				return true;
		return false;
	}

	@Override
	public boolean supportsUnboundedQuery() {		
		for(IUnaryPredicate pred : predicates)
			if(!pred.supportsUnboundedQuery())
				return false;
		return true;
	}

	@Override
	public void add(WriteGraph g, Resource r) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void remove(WriteGraph g, Resource r) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean supportsAddition() {
		return false;
	}

	@Override
	public boolean supportsRemoval() {		
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((predicates == null) ? 0 : predicates.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Disjunction other = (Disjunction) obj;
		if (predicates == null) {
			if (other.predicates != null)
				return false;
		} else if (!predicates.equals(other.predicates))
			return false;
		return true;
	}	
	
}
