/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.direct;

import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.PropertyReference;

public final class ResourceNameUtils {

    public static final char   NAME_PATH_DELIMITER        = '/';
    public static final String NAME_PATH_DELIMITER_STRING = "" + NAME_PATH_DELIMITER;

    public static String getName(ReadGraph g, Resource r) throws ValidationException, ServiceException {
    	Layer0 b = Layer0.getInstance(g);
        String name = (String) g.getPossibleRelatedValue(r, b.HasName);
        if (name == null)
            return "#" + r.getResourceId();
        else
            return URIStringUtils.escape(name);
    }

    public static String getName(ReadGraph g, PropertyReference ref) throws DatabaseException {
        return getName(g, ref.resources);
    }

    public static String getName(ReadGraph g, Resource[] ref) throws DatabaseException {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Resource r : ref) {
            if (first)
                first = false;
            else
                b.append(NAME_PATH_DELIMITER);
            b.append(getName(g, r));
        }
        return b.toString();
    }

}