/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jdbc.variable;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import com.impossibl.postgres.jdbc.PGDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.request.Read;
import org.simantics.jdbc.variable.JDBCNode;
import org.simantics.jdbc.variable.JDBCNodeManagerSupport;
import org.simantics.jdbc.variable.JDBCRealm;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardVariableSessionManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSessionManager
extends StandardVariableSessionManager<JDBCNode, JDBCNodeManagerSupport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCSessionManager.class);
    private static JDBCSessionManager INSTANCE = new JDBCSessionManager();
    private static final String VALUE_SIMANTICS_JDBC_HOST = "localhost";
    private static final int VALUE_SIMANTICS_JDBC_PORT = 5432;
    private static final String VALUE_SIMANTICS_JDBC_USER = "simantics";
    private static final String VALUE_SIMANTICS_JDBC_PASSWORD = "simantics";
    private static final String VALUE_SIMANTICS_JDBC_DATABASE = "simantics";
    private String channelName = "test";
    private PGNotificationListener listener;
    private PGDataSource dataSource;
    private Connection connection;

    private static Properties readProperties(InputStream s) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = s;){
            Properties props = new Properties();
            props.load(is);
            return props;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Properties safeReadProperties(URL url) {
        try {
            return JDBCSessionManager.readProperties(url.openStream());
        }
        catch (IOException e) {
            LOGGER.error("Could not read props from " + url, (Throwable)e);
            return null;
        }
    }

    private static Properties safeReadProperties(URI uri) {
        try {
            return JDBCSessionManager.safeReadProperties(uri.toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Could not read props from " + uri, (Throwable)e);
            return null;
        }
    }

    private static Properties safeReadProperties(String path) {
        return JDBCSessionManager.safeReadProperties(Paths.get(path, new String[0]).toUri());
    }

    private static Properties readProperties() {
        Properties p;
        String propFile = System.getProperty("simantics.jdbc.propertyfile", null);
        if (propFile != null && (p = JDBCSessionManager.safeReadProperties(propFile)) != null) {
            return p;
        }
        p = JDBCSessionManager.safeReadProperties(JDBCSessionManager.class.getClassLoader().getResource("jdbc.properties"));
        if (p != null) {
            p.putAll((Map<?, ?>)System.getProperties());
        } else {
            p = System.getProperties();
        }
        return p;
    }

    public JDBCSessionManager() {
        Properties props = JDBCSessionManager.readProperties();
        String host = props.getProperty("simantics.jdbc.host", VALUE_SIMANTICS_JDBC_HOST);
        String port = props.getProperty("simantics.jdbc.port", "5432");
        String database = props.getProperty("simantics.jdbc.database", "simantics");
        String user = props.getProperty("simantics.jdbc.user", "simantics");
        String password = props.getProperty("simantics.jdbc.password", "simantics");
        try {
            int portNumber = Integer.valueOf(port);
            this.dataSource = new PGDataSource();
            this.dataSource.setHost(host);
            this.dataSource.setPort(portNumber);
            this.dataSource.setDatabaseName(database);
            this.dataSource.setUser(user);
            this.dataSource.setPassword(password);
            this.connection = this.dataSource.getConnection();
            this.listener = new PGNotificationListener(){

                public void notification(int processId, String channelName, final String payload) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received notification from processId={} channelName={} and payload={}", new Object[]{processId, channelName, payload});
                    }
                    Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            for (String realmId : INSTANCE.getRealms()) {
                                try {
                                    JDBCRealm jdbcRealm = (JDBCRealm)INSTANCE.getOrCreateRealm(graph, realmId);
                                    jdbcRealm.getNodeManager().refreshVariable((Object)new JDBCNode(payload));
                                }
                                catch (DatabaseException e) {
                                    LOGGER.error("Could not refresh variable in realm {} with payload {}", new Object[]{realmId, payload, e});
                                }
                            }
                        }
                    });
                }
            };
            this.createTable();
            this.init();
        }
        catch (SQLException e) {
            LOGGER.error("Could not initialize JDBCSessionManager!", (Throwable)e);
        }
    }

    private void createTable() throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.execute("CREATE TABLE IF NOT EXISTS simantics_table (key VARCHAR UNIQUE, value JSON)");
        statement.close();
    }

    protected void init() throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.execute("LISTEN " + this.channelName);
        statement.close();
        ((PGConnection)this.connection).addNotificationListener(this.listener);
    }

    protected void destroy() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (PGConnection connection = (PGConnection)this.dataSource.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute("UNLISTEN " + this.channelName);
            statement.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected JDBCNodeManagerSupport createEngine(ReadGraph graph, String id) throws DatabaseException {
        return new JDBCNodeManagerSupport(id, this.dataSource, this.channelName);
    }

    protected StandardRealm<JDBCNode, JDBCNodeManagerSupport> createRealm(JDBCNodeManagerSupport engine, String id) {
        return new JDBCRealm(engine, id);
    }

    public static void setValue(ReadGraph graph, String id, String key, Object value) throws DatabaseException, NodeManagerException, BindingException, InterruptedException {
        JDBCRealm realm = (JDBCRealm)INSTANCE.getOrCreateRealm(graph, id);
        realm.asyncExec(() -> {
            try {
                realm.getNodeManager().setValue((Object)new JDBCNode(key), key, value, (Binding)Bindings.OBJECT);
            }
            catch (BindingException | NodeManagerException e) {
                LOGGER.error("Could not set value {} for {}", new Object[]{value, key, e});
            }
        });
    }

    public static NodeSupport<?> nodeSupport(ReadGraph graph, String sessionName) throws DatabaseException {
        return INSTANCE.getOrCreateNodeSupport(graph, sessionName);
    }

    public static Object getValue(ReadGraph graph, String uri, final String key) throws InterruptedException, DatabaseException {
        final JDBCRealm realm = (JDBCRealm)INSTANCE.getOrCreateRealm(graph, uri);
        return realm.syncExec(new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                try {
                    return realm.getNodeManager().getValue((Object)new JDBCNode(key), key).getValue();
                }
                catch (NodeManagerException e) {
                    LOGGER.error("Could not get value for {}", (Object)key, (Object)e);
                    return null;
                }
            }
        });
    }
}

