/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.issues.common.IssueUtils;

/**
 * @author Tuukka Lehtonen
 */
public class NewUserIssue extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Session session = Simantics.getSession();
            VirtualGraph vg = null;
            session.syncRequest(new WriteRequest(vg) {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Resource issue = IssueUtils.newUserIssueForModel(graph);
                    Layer0Utils.addCommentMetadata(graph, "Created new User Issue " + NameUtils.getSafeLabel(graph, issue) + " " + issue.toString()); //$NON-NLS-1$ //$NON-NLS-2$
                }
            });
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }
        return null;
    }

}