/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.Read;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.common.BatchValidations;
import org.simantics.issues.common.ManagedIssues;
import org.simantics.issues.common.Messages;
import org.simantics.issues.common.SelectedModelBatchIssueSources;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.preferences.IssuePreferenceUtil;

public class RunActiveValidations {
    public static void run(IProgressMonitor monitor) throws DatabaseException {
        Resource model = (Resource)Simantics.getSession().syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
        if (model != null) {
            RunActiveValidations.run(monitor, model);
        }
    }

    public static void run(IProgressMonitor monitor, Resource model) throws DatabaseException {
        Session session = Simantics.getSession();
        ArrayList<BatchIssueSource> validations = new ArrayList<BatchIssueSource>();
        BatchIssueValidationContext context = new BatchIssueValidationContext();
        try {
            RunActiveValidations.toBatchIssueSources((RequestProcessor)session, (Collection)session.syncRequest((Read)new SelectedModelBatchIssueSources(model)), validations);
            SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RunActiveValidations_MonitorPreparingResourcesForValidation, (int)100);
            context.contexts = Collections.singletonList(model);
            context.domain = ModelTransferableGraphSourceRequest.getDomainOnly((RequestProcessor)session, (IProgressMonitor)monitor, (Resource)model);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
        if (!validations.isEmpty() && !context.contexts.isEmpty()) {
            RunActiveValidations.run(monitor, validations, context);
        }
    }

    static Collection<BatchIssueSource> toBatchIssueSources(RequestProcessor processor, Collection<Resource> sources, Collection<BatchIssueSource> result) throws DatabaseException {
        for (Resource source : sources) {
            BatchIssueSource bis = (BatchIssueSource)processor.syncRequest(Queries.adapt((Resource)source, BatchIssueSource.class, (boolean)true));
            if (bis == null) continue;
            result.add(bis);
        }
        return result;
    }

    public static void run(IProgressMonitor monitor, Collection<BatchIssueSource> validations, BatchIssueValidationContext context) throws DatabaseException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RunActiveValidations_ValidateModel, (int)100);
        int maxWrittenIssues = IssuePreferenceUtil.getPreferences().maxBatchIssuesToWrite;
        int writtenIssues = 0;
        for (BatchIssueSource source : validations) {
            Map<Resource, Set<Issue>> results = BatchValidations.validate((IProgressMonitor)progress.newChild(90, 0), source, context);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection removed = (Collection)Simantics.getSession().syncRequest((Read)new ResourceRead<Collection<Resource>>(source.getResource()){

                public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    ArrayList<Resource> result = new ArrayList<Resource>();
                    for (Resource issue : (Collection)graph.syncRequest((Read)new ManagedIssues(this.resource))) {
                        Resource mainContext;
                        Resource list = graph.getSingleObject(issue, ISSUE.Issue_HasContexts);
                        List l = ListUtils.toList((ReadGraph)graph, (Resource)list);
                        if (l.size() <= 0 || BatchValidations.isLinkedToOtherThan(graph, mainContext = (Resource)l.get(0), issue)) continue;
                        result.add(mainContext);
                    }
                    return result;
                }
            });
            for (Resource r : removed) {
                results.put(r, Collections.emptySet());
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            int wroteIssues = BatchValidations.store((IProgressMonitor)progress.newChild(10, 0), source.getResource(), results, Math.max(0, maxWrittenIssues - writtenIssues));
            writtenIssues += wroteIssues;
            SessionGarbageCollection.gc(null, (Session)Simantics.getSession(), (boolean)true, null);
        }
    }
}

