/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Objects;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.FunctionImpl1;

class HideFunction
extends FunctionImpl1<Boolean, Boolean> {
    private Resource[] issues;

    public HideFunction(Resource ... issues) {
        this.issues = issues;
    }

    public Boolean apply(Boolean hide) {
        try {
            WriteGraph graph = Objects.requireNonNull((WriteGraph)SCLContext.getCurrent().get((Object)"graph"));
            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
            boolean changed = false;
            Resource[] resourceArray = this.issues;
            int n = this.issues.length;
            int n2 = 0;
            while (n2 < n) {
                Resource issue = resourceArray[n2];
                changed |= HideFunction.tag(graph, issue, ISSUE.Hidden, hide);
                ++n2;
            }
            return changed;
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    private static boolean tag(WriteGraph graph, final Resource r, final Resource tagRel, boolean tag) throws DatabaseException {
        boolean isTagged = graph.hasStatement(r, tagRel);
        if (tag && !isTagged) {
            VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = vgs.getGraph((ReadGraph)graph, r);
            if (vg != null) {
                graph.sync((WriteInterface)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.claim(r, tagRel, tagRel, r);
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Marking " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r) + " to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)tagRel)))));
                    }
                });
            } else {
                graph.claim(r, tagRel, tagRel, r);
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Marking " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r) + " to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)tagRel)))));
            }
            return true;
        }
        if (!tag && isTagged) {
            graph.deny(r, tagRel, tagRel, r);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Denying " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r) + " to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)tagRel)))));
            return true;
        }
        return false;
    }
}

