/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.common.ActiveProjectIssueSources;
import org.simantics.issues.ontology.IssueResource;

public class DynamicIssueSources
extends ResourceRead<Set<Variable>> {
    public DynamicIssueSources(Resource project) {
        super(project);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        THashSet result = new THashSet();
        for (Resource source : (Collection)graph.syncRequest((Read)new ActiveProjectIssueSources(this.resource, ISSUE.DynamicIssueSource))) {
            Variable v;
            boolean selected = graph.hasStatement(source, ISSUE.IssueSource_Selected);
            if (!selected || (v = (Variable)graph.syncRequest((Read)new PossibleVariable(source))) == null) continue;
            result.add(v);
        }
        return result;
    }
}

