/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.MaxIssueSeverityRecursive;

public class ChildMaxIssueSeverity
extends TernaryAsyncRead<Resource, Resource, Set<Resource>, Severity> {
    public ChildMaxIssueSeverity(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super((Object)resource, (Object)childRelation, typesToRecurse);
    }

    public void perform(AsyncReadGraph graph, AsyncProcedure<Severity> procedure) {
        try {
            Set types = graph.getTypes((Resource)this.parameter);
            if (!Collections.disjoint((Collection)this.parameter3, types)) {
                this.checkChildren(graph, procedure);
            } else {
                procedure.execute(graph, null);
            }
        }
        catch (DatabaseException e) {
            procedure.exception(graph, (Throwable)e);
        }
    }

    protected void checkChildren(AsyncReadGraph graph, AsyncProcedure<Severity> procedure) {
        final AsyncReadResult<Severity> maxSeverity = new AsyncReadResult<Severity>(procedure, new AtomicReference());
        try {
            Collection children = graph.getObjects((Resource)this.parameter, (Resource)this.parameter2);
            for (Resource child : children) {
                maxSeverity.inc();
                graph.asyncRequest((Read)new MaxIssueSeverityRecursive(child, (Resource)this.parameter2, (Set)this.parameter3), (AsyncProcedure)new AsyncProcedure<Severity>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Severity severity) {
                        if (severity != null) {
                            AsyncReadResult asyncReadResult = maxSeverity;
                            synchronized (asyncReadResult) {
                                maxSeverity.set(graph, Severity.moreSevere((Severity)((Severity)maxSeverity.resultRef.get()), (Severity)severity));
                            }
                        } else {
                            maxSeverity.dec(graph);
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        maxSeverity.except(graph, throwable);
                    }
                });
            }
            maxSeverity.dec(graph);
        }
        catch (DatabaseException e) {
            maxSeverity.except(graph, e);
            return;
        }
    }

    static class AsyncReadResult<T> {
        private AtomicReference<T> resultRef;
        private Throwable throwable;
        private AtomicInteger counter = new AtomicInteger(1);
        private AsyncProcedure<T> procedure;

        AsyncReadResult(AsyncProcedure<T> procedure, AtomicReference<T> resultRef) {
            this.procedure = procedure;
            this.resultRef = resultRef;
        }

        void except(AsyncReadGraph graph, Throwable throwable) {
            this.throwable = throwable;
            this.dec(graph);
        }

        void set(AsyncReadGraph graph, T result) {
            this.resultRef.set(result);
            this.dec(graph);
        }

        void inc() {
            this.counter.incrementAndGet();
        }

        void dec(AsyncReadGraph graph) {
            if (this.counter.decrementAndGet() == 0) {
                if (this.throwable != null) {
                    this.procedure.exception(graph, this.throwable);
                } else {
                    this.procedure.execute(graph, this.resultRef.get());
                }
            }
        }
    }
}

