/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common.preferences;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ui.ontology.IssueUIResource;

/**
 * @author Tuukka Lehtonen
 */
public final class IssuePrefs {

    public static boolean showHiddenIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, IssueUIResource.getInstance(graph).ShowHiddenIssues, false);
    }

    public static boolean showNormalIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, IssueUIResource.getInstance(graph).ShowNormalIssues, true);
    }

    public static boolean showUserIssues(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, IssueUIResource.getInstance(graph).ShowUserIssues, true);
    }

    private static boolean testBoolean(ReadGraph graph, Resource project, Resource property, boolean defaultValue) throws DatabaseException {
        if (project == null)
            return defaultValue;
        Boolean b = graph.getPossibleRelatedValue(project, property, Bindings.BOOLEAN);
        return b == null ? defaultValue : b;
    }

    public static void setShowHiddenIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, IssueUIResource.getInstance(graph).ShowHiddenIssues, show);
    }

    public static void setShowNormalIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, IssueUIResource.getInstance(graph).ShowNormalIssues, show);
    }

    public static void setShowUserIssues(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, IssueUIResource.getInstance(graph).ShowUserIssues, show);
    }

    private static void setBoolean(WriteGraph graph, Resource project, Resource property, boolean value)
            throws DatabaseException {
        graph.claimLiteral(project, property, value, Bindings.BOOLEAN);
    }

}
