package org.simantics.issues.common;

import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;

public class IssueByList extends BinaryRead<Resource, Issue, Resource> {

	public IssueByList(Resource source, Issue desc) {
		super(source, desc);
	}
	
	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
		for(Resource issue :  graph.syncRequest(new ManagedIssues(parameter))) {
			Issue list = graph.sync(new StandardIssueDescription(issue));
			if(list != null && list.equals(parameter2)) return issue;
		}
		return null;
	}
	
}