package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

public class BatchIssueDescriptions extends ResourceRead2<Set<Issue>> {

	public BatchIssueDescriptions(Resource source, Resource context) {
		super(source, context);
	}
	
	@Override
	public Set<Issue> perform(ReadGraph graph) throws DatabaseException {
		IssueResource ISSUE = IssueResource.getInstance(graph);
		Collection<Resource> issues = graph.syncRequest(new ManagedIssues(resource));
		if (issues.isEmpty())
			return Collections.emptySet();
		Set<Issue> result = new THashSet<Issue>(issues.size());
		for(Resource issue :  issues) {
	    	Resource list = graph.getSingleObject(issue, ISSUE.Issue_HasContexts);
	    	if(ListUtils.toList(graph, list).contains(resource2)) {
				result.add(graph.sync(new StandardIssueDescription(issue)));
			}
		}
		return result;
	}
	
}