/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

/**
 * @author Antti Villberg
 */
public class AllModelIssues extends BinaryRead<Resource, Boolean, Set<Resource>> {

    public AllModelIssues(Resource model) {
        super(model, Boolean.FALSE);
    }

    public AllModelIssues(Resource model, boolean onlyUnresolved) {
        super(model, onlyUnresolved);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Resource> result = new THashSet<Resource>();
        for (Resource issue : graph.syncRequest(new ObjectsWithType(parameter, L0.ConsistsOf, ISSUE.Issue))) {
            if (parameter2 && graph.hasStatement(issue, ISSUE.Resolved))
                continue;
            result.add(issue);
        }
        Instances indexedIssues = graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        if (indexedIssues != null)
            result.addAll(indexedIssues.find(graph, parameter));
        return result;
    }

}
