package org.simantics.issues.common;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class AllBatchIssueSources extends ResourceRead<Collection<BatchIssueSource>> {
	public AllBatchIssueSources(Resource model) {
		super(model);
	}

	@Override
	public Collection<BatchIssueSource> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		Collection<BatchIssueSource> result = new ArrayList<BatchIssueSource>();
		for (Resource source : graph.sync(new ObjectsWithType(resource, L0.ConsistsOf, IssueResource.getInstance(graph).IssueSource))) {
			BatchIssueSource bis = graph.syncRequest(Queries.adapt(source, BatchIssueSource.class, true));
			if(bis != null)
				result.add(bis);
		}
		return result;
	}
}