/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.TreeMap;
import org.simantics.databoard.annotations.Referable;

public class WeightedMedianApprox {
    static final Comparator<Item> valueComparator = new Comparator<Item>(){

        @Override
        public int compare(Item o1, Item o2) {
            double diff = o1.value - o2.value;
            return diff == 0.0 ? 0 : (diff < 0.0 ? -1 : 1);
        }
    };
    static final Comparator<Double> double_comparator;
    static final Comparator<Double> reverse_double_comparator;
    public Item median;
    public TreeMap<Double, Item> lower;
    public TreeMap<Double, Item> upper;
    public int maxSize = Integer.MAX_VALUE;
    public double rpos;

    static {
        reverse_double_comparator = new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                Double d1 = o1;
                Double d2 = o2;
                double d = d2 - d1;
                return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
            }
        };
        double_comparator = new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                Double d1 = o1;
                Double d2 = o2;
                double d = d1 - d2;
                return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
            }
        };
    }

    public WeightedMedianApprox() {
        this.lower = new TreeMap(reverse_double_comparator);
        this.upper = new TreeMap(double_comparator);
    }

    public WeightedMedianApprox(int maxSize) {
        this();
        this.maxSize = maxSize;
    }

    public void clear() {
        this.lower.clear();
        this.upper.clear();
        this.median = null;
        this.rpos = 0.0;
    }

    public void add(double weight, double value) {
        System.out.println("Adding (value=" + value + ", weight=" + weight + ")");
        if (this.median == null) {
            this.median = new Item(weight, value);
            this.rpos = weight / 2.0;
            return;
        }
        if (value == this.median.value) {
            this.median.weight += weight;
            return;
        }
        TreeMap<Double, Item> map = value > this.median.value ? this.upper : this.lower;
        Item i = map.get(value);
        if (i != null) {
            i.weight += weight;
        } else {
            map.put(value, new Item(weight, value));
        }
        this.rpos += (double)(value < this.median.value ? -1 : 1) * weight / 2.0;
        this.balance();
        int count = this.size();
        if (count > this.maxSize) {
            this.coalesce((count + 1) / 2);
        }
    }

    void balance() {
        while (this.rpos < 0.0) {
            this.upper.put(this.median.value, this.median);
            this.median = this.lower.remove(this.lower.firstKey());
            this.rpos += this.median.weight;
        }
        while (this.rpos >= this.median.weight) {
            this.rpos -= this.median.weight;
            this.lower.put(this.median.value, this.median);
            this.median = this.upper.remove(this.upper.firstKey());
        }
    }

    public double getMedian() {
        if (this.median == null) {
            return Double.NaN;
        }
        return this.median.value;
    }

    public int size() {
        return this.upper.size() + this.lower.size() + (this.median == null ? 0 : 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Median=" + this.getMedian() + " ");
        PriorityQueue<Item> q = new PriorityQueue<Item>(this.size(), valueComparator);
        q.addAll(this.lower.values());
        if (this.median != null) {
            q.add(this.median);
        }
        q.addAll(this.upper.values());
        while (!q.isEmpty()) {
            Item i = (Item)q.remove();
            sb.append("(value=");
            sb.append(i.value);
            sb.append(", w=");
            sb.append(i.weight);
            if (i == this.median) {
                sb.append(", pos=" + this.rpos);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public void coalesce(int targetCount) {
        int count = this.size();
        if (count < 3) {
            return;
        }
        ErrorStack err = new ErrorStack();
        err.start();
        for (Item item : this.lower.values()) {
            err.addItem(item);
        }
        err.addItem(this.median);
        for (Item item : this.upper.values()) {
            err.addItem(item);
        }
        MergeAction[] errs = err.finish();
        int i = targetCount - 1;
        while (i >= 0) {
            TreeMap<Double, Item> map;
            MergeAction e = errs[i];
            System.out.println("  Merging " + e.itemToMerge + " to " + e.mergeToItem + ", err=" + e.error);
            e.mergeToItem.weight += e.itemToMerge.weight;
            if (e.itemToMerge == this.median) {
                this.median = e.mergeToItem;
                map = e.mergeToItem.value < this.median.value ? this.lower : this.upper;
                map.remove(e.mergeToItem.value);
                if (e.itemToMerge.value < e.mergeToItem.value) {
                    this.rpos += e.itemToMerge.weight;
                    this.balance();
                }
            } else {
                map = e.itemToMerge.value < this.median.value ? this.lower : this.upper;
                map.remove(e.mergeToItem.value);
            }
            --i;
        }
    }

    class ErrorStack {
        MergeAction[] errs;
        int count;
        int i;
        Item prev;

        ErrorStack() {
        }

        void start() {
            this.count = WeightedMedianApprox.this.size();
            this.errs = new MergeAction[this.count - 1];
            this.i = 0;
            this.prev = null;
        }

        void addItem(Item item) {
            if (this.prev != null) {
                double mergeError;
                MergeAction e = new MergeAction();
                e.mergeToItem = this.prev;
                e.itemToMerge = item;
                double valueDiff = Math.abs(e.itemToMerge.value - e.mergeToItem.value);
                e.error = mergeError = valueDiff * e.itemToMerge.weight;
                this.errs[this.i++] = e;
            }
            this.prev = item;
        }

        MergeAction[] finish() {
            MergeErrorComparator c = new MergeErrorComparator();
            c.median = WeightedMedianApprox.this.median != null ? WeightedMedianApprox.this.median.value : 0.0;
            Arrays.sort(this.errs, c);
            return this.errs;
        }
    }

    @Referable
    public static class Item {
        public double weight;
        public double value;

        public Item() {
        }

        public Item(double weight, double value) {
            this.weight = weight;
            this.value = value;
        }

        public String toString() {
            return "(value=" + this.value + ", w=" + this.weight + ")";
        }
    }

    static class MergeAction {
        public double error;
        public Item mergeToItem;
        public Item itemToMerge;

        MergeAction() {
        }
    }

    static class MergeErrorComparator
    implements Comparator<MergeAction> {
        double median;

        MergeErrorComparator() {
        }

        @Override
        public int compare(MergeAction o1, MergeAction o2) {
            double diff = o1.error - o2.error;
            if (diff == 0.0) {
                double distToMedian1 = o1.mergeToItem.value - this.median;
                double distToMedian2 = o2.mergeToItem.value - this.median;
                diff = distToMedian1 - distToMedian2;
                return diff > 0.0 ? -1 : 1;
            }
            return diff < 0.0 ? -1 : 1;
        }
    }
}

