/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.RecordType;
import org.simantics.history.HistoryException;

public class ValueBand {
    public static final Byte QUALITY_GOOD = 0;
    public static final Byte QUALITY_NOVALUE = -1;
    protected RecordBinding binding;
    protected RecordType type;
    protected Object sample;
    FieldAdapter timeField;
    FieldAdapter endTimeField;
    FieldAdapter valueField;
    FieldAdapter lastValueField;
    FieldAdapter avgField;
    FieldAdapter medianField;
    FieldAdapter minField;
    FieldAdapter maxField;
    FieldAdapter countField;
    FieldAdapter qualityField;
    Object defaultValue;

    public ValueBand(Binding sampleBinding) {
        if (!(sampleBinding instanceof RecordBinding)) {
            throw new IllegalArgumentException();
        }
        this.binding = (RecordBinding)sampleBinding;
        this.type = this.binding.type();
        this.timeField = new FieldAdapter("time");
        this.endTimeField = new FieldAdapter("endTime");
        this.valueField = new FieldAdapter("value");
        this.lastValueField = new FieldAdapter("lastValue");
        this.avgField = new FieldAdapter("avg");
        this.medianField = new FieldAdapter("median");
        this.minField = new FieldAdapter("min");
        this.maxField = new FieldAdapter("max");
        this.countField = new FieldAdapter("count");
        this.qualityField = new FieldAdapter("quality");
        try {
            this.defaultValue = this.binding.createDefault();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public ValueBand(Binding sampleBinding, Object sample) {
        this(sampleBinding);
        this.sample = sample;
    }

    public void reset() {
        try {
            this.binding.readFrom((Binding)this.binding, this.defaultValue, this.sample);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    public Object getSample() {
        return this.sample;
    }

    public void setSample(Object sample) {
        this.sample = sample;
    }

    public void writeSample(Object sample) {
        try {
            this.binding.readFrom((Binding)this.binding, sample, this.sample);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void writeSample(Binding binding, Object sample) {
        try {
            binding.readFrom(binding, sample, this.sample);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public boolean hasTime() {
        return this.timeField.isEnabled();
    }

    public Binding getTimeBinding() {
        return this.timeField.binding;
    }

    public Object getTime() throws HistoryException {
        return this.timeField.getValue();
    }

    public Object getTime(Binding b) throws HistoryException {
        return this.timeField.getValue(b);
    }

    public double getTimeDouble() throws HistoryException {
        return this.timeField.getDoubleValue();
    }

    public void setTime(Object v) throws HistoryException {
        this.timeField.setValue(v);
    }

    public void setTime(Binding binding, Object v) throws HistoryException {
        this.timeField.setValue(binding, v);
    }

    public boolean hasEndTime() {
        return this.endTimeField.isEnabled();
    }

    public Binding getEndTimeBinding() {
        return this.endTimeField.binding;
    }

    public Object getEndTime() throws HistoryException {
        return this.endTimeField.getValue();
    }

    public Object getEndTime(Binding b) throws HistoryException {
        return this.endTimeField.getValue(b);
    }

    public double getEndTimeDouble() throws HistoryException {
        return this.endTimeField.getDoubleValue();
    }

    public void setEndTime(Object v) throws HistoryException {
        this.endTimeField.setValue(v);
    }

    public void setEndTime(Binding binding, Object v) throws HistoryException {
        this.endTimeField.setValue(binding, v);
    }

    public boolean hasValue() {
        return this.valueField.isEnabled();
    }

    public Binding getValueBinding() {
        return this.valueField.binding;
    }

    public Object getValue() throws HistoryException {
        return this.valueField.getValue();
    }

    public Object getValue(Binding b) throws HistoryException {
        return this.valueField.getValue(b);
    }

    public double getValueDouble() throws HistoryException {
        return this.valueField.getDoubleValue();
    }

    public Object getPossibleValue() throws HistoryException {
        if (this.isNullValue()) {
            return null;
        }
        return this.valueField.getValue();
    }

    public Object getPossibleValue(Binding b) throws HistoryException {
        if (this.isNullValue()) {
            return null;
        }
        return this.valueField.getValue(b);
    }

    public Double getPossibleValueDouble() throws HistoryException {
        if (this.isNullValue()) {
            return null;
        }
        return this.valueField.getDoubleValue();
    }

    public boolean getValueBoolean() throws HistoryException {
        return this.valueField.getBooleanValue();
    }

    public void setValue(Object v) throws HistoryException {
        this.valueField.setValue(v);
    }

    public void setValue(Binding binding, Object v) throws HistoryException {
        this.valueField.setValue(binding, v);
    }

    public boolean hasLastValue() {
        return this.lastValueField.isEnabled();
    }

    public Binding getLastValueBinding() {
        return this.lastValueField.binding;
    }

    public Object getLastValue() throws HistoryException {
        return this.lastValueField.getValue();
    }

    public Object getLastValue(Binding b) throws HistoryException {
        return this.lastValueField.getValue(b);
    }

    public void setLastValue(Object v) throws HistoryException {
        this.lastValueField.setValue(v);
    }

    public void setLastValue(Binding binding, Object v) throws HistoryException {
        this.lastValueField.setValue(binding, v);
    }

    public boolean hasAvg() {
        return this.avgField.isEnabled();
    }

    public Binding getAvgBinding() {
        return this.avgField.binding;
    }

    public Object getAvg() throws HistoryException {
        return this.avgField.getValue();
    }

    public Object getAvg(Binding b) throws HistoryException {
        return this.avgField.getValue(b);
    }

    public double getAvgDouble() throws HistoryException {
        return this.avgField.getDoubleValue();
    }

    public void setAvg(Object v) throws HistoryException {
        this.avgField.setValue(v);
    }

    public void setAvg(Binding binding, Object v) throws HistoryException {
        this.avgField.setValue(binding, v);
    }

    public boolean hasMedian() {
        return this.medianField.isEnabled();
    }

    public Binding getMedianBinding() {
        return this.medianField.binding;
    }

    public Object getMedian() throws HistoryException {
        return this.medianField.getValue();
    }

    public Object getMedian(Binding b) throws HistoryException {
        return this.medianField.getValue(b);
    }

    public double getMedianDouble() throws HistoryException {
        return this.medianField.getDoubleValue();
    }

    public void setMedian(Object v) throws HistoryException {
        this.medianField.setValue(v);
    }

    public void setMedian(Binding binding, Object v) throws HistoryException {
        this.medianField.setValue(binding, v);
    }

    public boolean hasMin() {
        return this.minField.isEnabled();
    }

    public Binding getMinBinding() {
        return this.minField.binding;
    }

    public Object getMin() throws HistoryException {
        return this.minField.getValue();
    }

    public Object getMin(Binding b) throws HistoryException {
        return this.minField.getValue(b);
    }

    public double getMinDouble() throws HistoryException {
        return this.minField.getDoubleValue();
    }

    public void setMin(Object v) throws HistoryException {
        this.minField.setValue(v);
    }

    public void setMin(Binding binding, Object v) throws HistoryException {
        this.minField.setValue(binding, v);
    }

    public boolean hasMax() {
        return this.maxField.isEnabled();
    }

    public Binding getMaxBinding() {
        return this.maxField.binding;
    }

    public Object getMax() throws HistoryException {
        return this.maxField.getValue();
    }

    public Object getMax(Binding b) throws HistoryException {
        return this.maxField.getValue(b);
    }

    public double getMaxDouble() throws HistoryException {
        return this.maxField.getDoubleValue();
    }

    public void setMax(Object v) throws HistoryException {
        this.maxField.setValue(v);
    }

    public void setMax(Binding binding, Object v) throws HistoryException {
        this.maxField.setValue(binding, v);
    }

    public boolean hasCount() {
        return this.countField.isEnabled();
    }

    public NumberBinding getCountBinding() {
        return (NumberBinding)this.countField.binding;
    }

    public int getCount() throws HistoryException {
        Integer i = (Integer)this.countField.getValue((Binding)Bindings.INTEGER);
        return i == null ? 0 : i;
    }

    public Object getCount(Binding b) throws HistoryException {
        return this.countField.getValue(b);
    }

    public void setCount(int v) throws HistoryException {
        this.countField.setValue((Binding)Bindings.INTEGER, v);
    }

    public boolean hasQuality() {
        return this.qualityField.isEnabled();
    }

    public Binding getQualityBinding() {
        return this.qualityField.binding;
    }

    public Object getQuality() throws HistoryException {
        return this.qualityField.getValue();
    }

    public Object getQuality(Binding b) throws HistoryException {
        return this.qualityField.getValue(b);
    }

    public void setQuality(Object v) throws HistoryException {
        this.qualityField.setValue(v);
    }

    public void setQuality(Binding binding, Object v) throws HistoryException {
        this.qualityField.setValue(binding, v);
    }

    public boolean isRanged() {
        return this.endTimeField.isEnabled();
    }

    public boolean isValidValue() throws HistoryException {
        return !this.isNanSample() && !this.isNullValue();
    }

    public boolean isNanSample() {
        try {
            if (this.valueField.binding instanceof DoubleBinding) {
                DoubleBinding db = (DoubleBinding)this.valueField.binding;
                double d = db.getValue_(this.binding.getComponent(this.sample, this.valueField.index));
                return Double.isNaN(d);
            }
            if (this.valueField.binding instanceof FloatBinding) {
                FloatBinding db = (FloatBinding)this.valueField.binding;
                float d = db.getValue_(this.binding.getComponent(this.sample, this.valueField.index));
                return Float.isNaN(d);
            }
            return false;
        }
        catch (BindingException bindingException) {
            return false;
        }
    }

    public boolean supportsNullValue() {
        return this.qualityField.isEnabled();
    }

    public void setValueNull() throws HistoryException {
        this.qualityField.setValue((Binding)Bindings.BYTE, QUALITY_NOVALUE);
    }

    public boolean isNullValue() throws HistoryException {
        Byte b = (Byte)this.qualityField.getValue((Binding)Bindings.BYTE);
        return b == null ? false : b.equals(QUALITY_NOVALUE);
    }

    public boolean isNumericValue() {
        return this.valueField.isNumeric();
    }

    public String toString() {
        try {
            return this.binding.toString(this.sample);
        }
        catch (BindingException e) {
            return e.toString();
        }
    }

    class FieldAdapter {
        Binding binding;
        Binding adapter1binding;
        Adapter adapter1;
        Binding adapter2binding;
        Adapter adapter2;
        int index;
        String fieldName;

        public FieldAdapter(String fieldName) {
            this.fieldName = fieldName;
            this.index = ValueBand.this.binding.type().getComponentIndex2(fieldName);
            if (this.index < 0) {
                return;
            }
            this.binding = ValueBand.this.binding.getComponentBinding(this.index);
        }

        public boolean getBooleanValue() throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return false;
            }
            try {
                Object value = ValueBand.this.binding.getComponent(ValueBand.this.sample, this.index);
                if (this.binding instanceof BooleanBinding) {
                    return ValueBand.this.binding.getBoolean(ValueBand.this.sample, this.index);
                }
                if (this.binding instanceof ByteBinding) {
                    ByteBinding nb = (ByteBinding)this.binding;
                    return nb.getValue_(value) != 0;
                }
                if (this.binding instanceof DoubleBinding) {
                    DoubleBinding nb = (DoubleBinding)this.binding;
                    return nb.getValue_(value) != 0.0;
                }
                if (this.binding instanceof NumberBinding) {
                    NumberBinding nb = (NumberBinding)this.binding;
                    return nb.getValue(value).doubleValue() != 0.0;
                }
                return false;
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
        }

        public double getDoubleValue() throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return Double.NaN;
            }
            try {
                if (this.binding != Bindings.DOUBLE) {
                    Object result = ValueBand.this.binding.getComponent(ValueBand.this.sample, this.index);
                    result = Bindings.adapt((Object)result, (Binding)this.binding, (Binding)Bindings.DOUBLE);
                    return (Double)result;
                }
                return ValueBand.this.binding.getDouble(ValueBand.this.sample, this.index);
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
            catch (AdaptException e) {
                throw new HistoryException(e);
            }
        }

        public boolean isEnabled() {
            return this.index >= 0;
        }

        public Object getValue() throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return null;
            }
            try {
                Object result = ValueBand.this.binding.getComponent(ValueBand.this.sample, this.index);
                return result;
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
        }

        public Object getValue(Binding binding) throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return null;
            }
            try {
                Object result = ValueBand.this.binding.getComponent(ValueBand.this.sample, this.index);
                if (binding != this.binding) {
                    if (binding != this.adapter2binding) {
                        this.adapter2 = Bindings.adapterFactory.getAdapter(this.binding, binding, true, false);
                        this.adapter2binding = binding;
                    }
                    result = this.adapter2.adapt(result);
                }
                return result;
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
            catch (AdaptException e) {
                throw new HistoryException(e);
            }
            catch (AdapterConstructionException e) {
                throw new HistoryException(e);
            }
        }

        public void setValue(Object object) throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return;
            }
            this.setValue(this.binding, object);
        }

        public void setValue(Binding binding, Object object) throws HistoryException {
            if (ValueBand.this.sample == null || this.index == -1) {
                return;
            }
            try {
                if (this.binding != binding) {
                    if (binding != this.adapter1binding) {
                        this.adapter1 = Bindings.adapterFactory.getAdapter(binding, this.binding, true, !binding.isImmutable());
                        this.adapter1binding = binding;
                    }
                    object = this.adapter1.adapt(object);
                }
                ValueBand.this.binding.setComponent(ValueBand.this.sample, this.index, object);
            }
            catch (AdaptException e) {
                throw new HistoryException(e);
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
            catch (AdapterConstructionException e) {
                throw new HistoryException(e);
            }
        }

        public boolean isNumeric() {
            return this.binding instanceof NumberBinding;
        }
    }
}

