/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.ui;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.continuation.Computation;
import org.simantics.graphviz.continuation.Continuation;
import org.simantics.graphviz.drawable.Drawable;
import org.simantics.graphviz.drawable.GraphDrawable;
import org.simantics.graphviz.drawable.ViewerCanvas;
import org.simantics.utils.ui.SWTUtils;

public class GraphvizComponent
extends Composite {
    Canvas canvas;
    GraphDrawable drawable;
    Graph graph;
    AtomicBoolean initialized = new AtomicBoolean(false);

    public GraphvizComponent(Composite parent, int style) {
        super(parent, style | 0x1000000 | 0x40000);
        final Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.workaroundJava7FocusProblem(frame);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GraphvizComponent.this.drawable = new GraphDrawable();
                    GraphvizComponent.this.canvas = new ViewerCanvas((Drawable)GraphvizComponent.this.drawable);
                    frame.add(GraphvizComponent.this.canvas);
                }
                catch (Throwable throwable) {
                    AtomicBoolean atomicBoolean = GraphvizComponent.this.initialized;
                    synchronized (atomicBoolean) {
                        GraphvizComponent.this.initialized.set(true);
                        GraphvizComponent.this.initialized.notifyAll();
                    }
                    throw throwable;
                }
                AtomicBoolean atomicBoolean = GraphvizComponent.this.initialized;
                synchronized (atomicBoolean) {
                    GraphvizComponent.this.initialized.set(true);
                    GraphvizComponent.this.initialized.notifyAll();
                }
            }
        });
    }

    private void workaroundJava7FocusProblem(Frame frame) {
        String ver = System.getProperty("java.version");
        if (ver.startsWith("1.7") || ver.startsWith("1.8")) {
            try {
                frame.addWindowListener(new Java7FocusFixListener((Control)this, frame));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilInitialized() {
        try {
            AtomicBoolean atomicBoolean = this.initialized;
            synchronized (atomicBoolean) {
                while (!this.initialized.get()) {
                    this.initialized.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("GraphvizComponent AWT population interrupted for class " + (Object)((Object)this), e);
        }
    }

    public void setGraph(Graph graph) {
        this.setGraph(graph, "dot");
    }

    public Computation<Graph> setGraph(Graph graph, String algorithm) {
        this.waitUntilInitialized();
        Computation computation = this.drawable.setGraph(graph, algorithm);
        computation.addContinuation((Continuation)new Continuation<Graph>(){

            public void succeeded(Graph result) {
                if (GraphvizComponent.this.isDisposed()) {
                    return;
                }
                GraphvizComponent.this.fit();
            }

            public void failed(Exception exception) {
            }
        });
        return computation;
    }

    public void fit() {
        ((ViewerCanvas)this.canvas).fit();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GraphvizComponent.this.isDisposed()) {
                    GraphvizComponent.this.redraw();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphvizComponent.this.canvas.repaint();
            }
        });
    }

    public void requestFocus() {
        if (this.canvas != null) {
            this.canvas.requestFocus();
        }
    }

    public void save(File file) throws IOException {
        if (this.drawable == null) {
            throw new IOException("Nothing to save");
        }
        Graph graph = this.drawable.getGraph();
        String algo = this.drawable.getAlgorithm();
        String type = GraphvizComponent.getExtension(file);
        if (type == null) {
            return;
        }
        Graphs.createImage((Graph)graph, (String)algo, (String)type, (File)file);
    }

    public String[] getFileExtensions() {
        return new String[]{"*.svg", "*.dot", "*.eps", "*.jpg", "*.jpeg", "*.pdf", "*.png", "*.ps"};
    }

    public String[] getFileNames() {
        return new String[]{"Scalable Vector Graphics Image", "DOT Image", "Encapsulated PostScript Image", "JPG Image", "JPG Image", "Portable Document Format Image", "Portable Network Graphics Image", "PostScript Image"};
    }

    public static String getExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return filename.substring(index + 1).toLowerCase();
    }

    static class Java7FocusFixListener
    extends WindowAdapter {
        Method shellSetActiveControl = Shell.class.getDeclaredMethod("setActiveControl", Control.class);
        Control control;
        Frame frame;

        public Java7FocusFixListener(Control control, Frame frame) throws NoSuchMethodException, SecurityException {
            this.frame = frame;
            this.control = control;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SWTUtils.asyncExec((Widget)this.control, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (control.isDisposed()) {
                        return;
                    }
                    if (control.getDisplay().getFocusControl() == control) {
                        try {
                            boolean accessible = shellSetActiveControl.isAccessible();
                            if (!accessible) {
                                shellSetActiveControl.setAccessible(true);
                            }
                            shellSetActiveControl.invoke((Object)control.getShell(), control);
                            if (!accessible) {
                                shellSetActiveControl.setAccessible(false);
                            }
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.getCause().printStackTrace();
                        }
                    }
                }
            });
        }
    }
}

