/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public class FilledShape implements ShapeCommand {
	protected Shape shape;
	
	public FilledShape(Shape shape) {
		this.shape = shape;
	}

	@Override
	public void draw(Graphics2D g) {
	    Color curColor = g.getColor();
	    g.setColor(SetFillColor.getFillColor());
		g.fill(shape);
		g.setColor(curColor);
		g.draw(shape);
	}
	
	@Override
	public Shape getShape() {
		return shape;
	}
}
