/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphfile.hack;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

public class GraphPath implements IPath {
	
	private GraphFile file;
	List<String> path = new ArrayList<String>();
	
	public GraphPath(GraphFile f) {
		this.file = f;
		try {
			Simantics.getSession().syncRequest(new ReadRequest() {
				
				@Override
				public void run(ReadGraph graph) throws DatabaseException {
					Layer0 l0 = Layer0.getInstance(graph);
					GraphFileResource gf = GraphFileResource.getInstance(graph);
					Resource fileResource = file.getFileResource();
					Resource t = fileResource;
					while (true) {
						t = graph.getPossibleObject(t, gf.PartOfSystemResource);
						if (t != null) {
							path.add(0, (String)graph.getRelatedValue(t, l0.HasName));
						} else {
							break;
						}
					}
					
				}
			});
		} catch (DatabaseException e) {
			throw new RuntimeException("Could not evaluate graph path",e);
		}
	}

	@Override
	public IPath addFileExtension(String extension) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath addTrailingSeparator() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath append(String path) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath append(IPath path) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDevice() {
		return "SimanticsGraph";
	}

	@Override
	public String getFileExtension() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasTrailingSeparator() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isAbsolute() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isEmpty() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isPrefixOf(IPath anotherPath) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isRoot() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isUNC() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isValidPath(String path) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isValidSegment(String segment) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public String lastSegment() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath makeAbsolute() {
		return this;
	}

	@Override
	public IPath makeRelative() {
		return this;
	}

	@Override
	public IPath makeRelativeTo(IPath base) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath makeUNC(boolean toUNC) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int matchingFirstSegments(IPath anotherPath) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public IPath removeFileExtension() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath removeFirstSegments(int count) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath removeLastSegments(int count) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath removeTrailingSeparator() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String segment(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int segmentCount() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String[] segments() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath setDevice(String device) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public File toFile() {
		// TODO Auto-generated method stub
		return new GraphJavaFile(file.getFileResource());
	}

	@Override
	public String toOSString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String toPortableString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPath uptoSegment(int count) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object clone()  {
		return null;
	}
	
	@Override
	public String toString() {
		String name = "";
		for (String s : path) {
			name+= s + SEPARATOR; 
		}
		name += file.getName();
		return name;
	}

}
