package org.simantics.graphfile.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class GraphFileResource {
    
    public final Resource File;
    public final Resource Folder;
    public final Resource HasFile;
    public final Resource HasFile_Inverse;
    public final Resource HasFiledata;
    public final Resource HasFiledata_Inverse;
    public final Resource HasFolder;
    public final Resource HasFolder_Inverse;
    public final Resource HasResourceName;
    public final Resource HasResourceName_Inverse;
    public final Resource HasSystemResource;
    public final Resource LastModified;
    public final Resource LastModified_Inverse;
    public final Resource PartOfSystemResource;
    public final Resource SystemPath;
    public final Resource SystemPath_Inverse;
    public final Resource SystemResource;
        
    public static class URIs {
        public static final String File = "http://www.simantics.org/GraphFile-0.1/File";
        public static final String Folder = "http://www.simantics.org/GraphFile-0.1/Folder";
        public static final String HasFile = "http://www.simantics.org/GraphFile-0.1/HasFile";
        public static final String HasFile_Inverse = "http://www.simantics.org/GraphFile-0.1/HasFile/Inverse";
        public static final String HasFiledata = "http://www.simantics.org/GraphFile-0.1/HasFiledata";
        public static final String HasFiledata_Inverse = "http://www.simantics.org/GraphFile-0.1/HasFiledata/Inverse";
        public static final String HasFolder = "http://www.simantics.org/GraphFile-0.1/HasFolder";
        public static final String HasFolder_Inverse = "http://www.simantics.org/GraphFile-0.1/HasFolder/Inverse";
        public static final String HasResourceName = "http://www.simantics.org/GraphFile-0.1/HasResourceName";
        public static final String HasResourceName_Inverse = "http://www.simantics.org/GraphFile-0.1/HasResourceName/Inverse";
        public static final String HasSystemResource = "http://www.simantics.org/GraphFile-0.1/HasSystemResource";
        public static final String LastModified = "http://www.simantics.org/GraphFile-0.1/LastModified";
        public static final String LastModified_Inverse = "http://www.simantics.org/GraphFile-0.1/LastModified/Inverse";
        public static final String PartOfSystemResource = "http://www.simantics.org/GraphFile-0.1/PartOfSystemResource";
        public static final String SystemPath = "http://www.simantics.org/GraphFile-0.1/SystemPath";
        public static final String SystemPath_Inverse = "http://www.simantics.org/GraphFile-0.1/SystemPath/Inverse";
        public static final String SystemResource = "http://www.simantics.org/GraphFile-0.1/SystemResource";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public GraphFileResource(ReadGraph graph) {
        File = getResourceOrNull(graph, URIs.File);
        Folder = getResourceOrNull(graph, URIs.Folder);
        HasFile = getResourceOrNull(graph, URIs.HasFile);
        HasFile_Inverse = getResourceOrNull(graph, URIs.HasFile_Inverse);
        HasFiledata = getResourceOrNull(graph, URIs.HasFiledata);
        HasFiledata_Inverse = getResourceOrNull(graph, URIs.HasFiledata_Inverse);
        HasFolder = getResourceOrNull(graph, URIs.HasFolder);
        HasFolder_Inverse = getResourceOrNull(graph, URIs.HasFolder_Inverse);
        HasResourceName = getResourceOrNull(graph, URIs.HasResourceName);
        HasResourceName_Inverse = getResourceOrNull(graph, URIs.HasResourceName_Inverse);
        HasSystemResource = getResourceOrNull(graph, URIs.HasSystemResource);
        LastModified = getResourceOrNull(graph, URIs.LastModified);
        LastModified_Inverse = getResourceOrNull(graph, URIs.LastModified_Inverse);
        PartOfSystemResource = getResourceOrNull(graph, URIs.PartOfSystemResource);
        SystemPath = getResourceOrNull(graph, URIs.SystemPath);
        SystemPath_Inverse = getResourceOrNull(graph, URIs.SystemPath_Inverse);
        SystemResource = getResourceOrNull(graph, URIs.SystemResource);
    }
    
    public static GraphFileResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        GraphFileResource ret = session.peekService(GraphFileResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new GraphFileResource(qc.getIndependentGraph(graph));
            session.registerService(GraphFileResource.class, ret);
        }
        return ret;
    }
    
    public static GraphFileResource getInstance(RequestProcessor session) throws DatabaseException {
        GraphFileResource ret = session.peekService(GraphFileResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<GraphFileResource>() {
                public GraphFileResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new GraphFileResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(GraphFileResource.class, ret);
        }
        return ret;
    }
    
}

