/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.store;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.graph.store.IStatementProcedure;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;
import org.simantics.graph.store.StatementCollision;

public class StatementStore
implements IStore {
    private static final TIntArrayList EMPTY_INT_LIST = new TIntArrayList(0);
    TIntObjectHashMap<TIntObjectHashMap<TIntArrayList>> statements = new TIntObjectHashMap();

    public void add(int subject, int predicate, int object) {
        TIntArrayList objects;
        assert (subject >= 0);
        assert (predicate >= 0);
        assert (object >= 0);
        TIntObjectHashMap localStatements = (TIntObjectHashMap)this.statements.get(subject);
        if (localStatements == null) {
            localStatements = new TIntObjectHashMap(3);
            this.statements.put(subject, (Object)localStatements);
        }
        if ((objects = (TIntArrayList)localStatements.get(predicate)) == null) {
            objects = new TIntArrayList(2);
            localStatements.put(predicate, (Object)objects);
        }
        objects.add(object);
    }

    @Override
    public void map(final TIntIntHashMap map) {
        final TIntObjectHashMap newStatements = new TIntObjectHashMap(this.statements.size() * 2 + 1);
        this.statements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>>(){
            TIntObjectHashMap<TIntArrayList> newLocalStatements;
            TIntArrayList newObjects;
            TIntProcedure objectProcedure;
            TIntObjectProcedure<TIntArrayList> predicateProcedure;
            {
                this.objectProcedure = new TIntProcedure(){

                    public boolean execute(int o) {
                        if (tIntIntHashMap.contains(o)) {
                            o = tIntIntHashMap.get(o);
                        }
                        newObjects.add(o);
                        return true;
                    }
                };
                this.predicateProcedure = new TIntObjectProcedure<TIntArrayList>(){

                    public boolean execute(int p, TIntArrayList objects) {
                        TIntArrayList exObjects;
                        if (tIntIntHashMap.contains(p)) {
                            p = tIntIntHashMap.get(p);
                        }
                        if ((exObjects = (TIntArrayList)newLocalStatements.get(p)) == null) {
                            IndexMappingUtils.map(tIntIntHashMap, objects);
                            newLocalStatements.put(p, (Object)objects);
                        } else {
                            newObjects = exObjects;
                            objects.forEach(objectProcedure);
                        }
                        return true;
                    }
                };
            }

            public boolean execute(int s, TIntObjectHashMap<TIntArrayList> localStatements) {
                TIntObjectHashMap exLocalStatements;
                if (map.contains(s)) {
                    s = map.get(s);
                }
                if ((exLocalStatements = (TIntObjectHashMap)newStatements.get(s)) == null) {
                    exLocalStatements = new TIntObjectHashMap(localStatements.size() * 2 + 1);
                    newStatements.put(s, (Object)exLocalStatements);
                }
                this.newLocalStatements = exLocalStatements;
                localStatements.forEachEntry(this.predicateProcedure);
                return true;
            }
        });
        this.statements = newStatements;
    }

    public void forStatements(final IStatementProcedure proc) {
        this.statements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>>(){

            public boolean execute(final int s, TIntObjectHashMap<TIntArrayList> localStatements) {
                localStatements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntArrayList>(){

                    public boolean execute(final int p, TIntArrayList objects) {
                        objects.forEach(new TIntProcedure(){

                            public boolean execute(int o) {
                                proc.execute(s, p, o);
                                return true;
                            }
                        });
                        return true;
                    }
                });
                return true;
            }
        });
    }

    public void forStatementsWithSubject(int s, IStatementProcedure proc) {
        TIntObjectHashMap localStatements = (TIntObjectHashMap)this.statements.get(s);
        if (localStatements == null) {
            return;
        }
        localStatements.forEachEntry((TIntObjectProcedure)new ForStatementsWithSubjectProc(s, proc));
    }

    public void forStatements(final int predicate, final IStatementProcedure proc) {
        this.statements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>>(){

            public boolean execute(final int s, TIntObjectHashMap<TIntArrayList> localStatements) {
                TIntArrayList objects = (TIntArrayList)localStatements.get(predicate);
                if (objects != null) {
                    objects.forEach(new TIntProcedure(){

                        public boolean execute(int o) {
                            proc.execute(s, predicate, o);
                            return true;
                        }
                    });
                }
                return true;
            }
        });
    }

    public TIntArrayList getRelation(int predicate) {
        final TIntArrayList result = new TIntArrayList();
        this.forStatements(predicate, new IStatementProcedure(){

            @Override
            public void execute(int s, int p, int o) {
                result.add(s);
                result.add(o);
            }
        });
        return result;
    }

    public TIntHashSet getRelationDomain(final int predicate) {
        final TIntHashSet result = new TIntHashSet();
        this.statements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>>(){

            public boolean execute(int s, TIntObjectHashMap<TIntArrayList> localStatements) {
                if (localStatements.containsKey(predicate)) {
                    result.add(s);
                }
                return true;
            }
        });
        return result;
    }

    public TIntArrayList extractRelation(final int predicate) {
        final TIntArrayList result = new TIntArrayList();
        final TIntArrayList removals = new TIntArrayList();
        this.statements.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>>(){

            public boolean execute(int s, TIntObjectHashMap<TIntArrayList> localStatements) {
                TIntArrayList objects = (TIntArrayList)localStatements.remove(predicate);
                if (objects != null) {
                    int[] nArray = objects.toArray();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int o = nArray[n2];
                        result.add(s);
                        result.add(o);
                        ++n2;
                    }
                }
                if (localStatements.isEmpty()) {
                    removals.add(s);
                }
                return true;
            }
        });
        int[] nArray = removals.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            this.statements.remove(s);
            ++n2;
        }
        return result;
    }

    public TIntArrayList getObjects(int subject, int predicate) {
        TIntObjectHashMap localStatements = (TIntObjectHashMap)this.statements.get(subject);
        if (localStatements == null) {
            return EMPTY_INT_LIST;
        }
        TIntArrayList objects = (TIntArrayList)localStatements.get(predicate);
        if (objects == null) {
            return EMPTY_INT_LIST;
        }
        return objects;
    }

    public int[] toArray(final TIntIntHashMap inverseMap) {
        final TIntArrayList statements = new TIntArrayList();
        this.forStatements(new IStatementProcedure(){

            @Override
            public void execute(int s, int p, int o) {
                statements.add(s);
                statements.add(p);
                int inverse = -1;
                if (inverseMap.contains(p) && p == (inverse = inverseMap.get(p)) && s == o) {
                    inverse = -1;
                }
                statements.add(inverse);
                statements.add(o);
            }
        });
        return statements.toArray();
    }

    public void collectReferences(final boolean[] set) {
        this.forStatements(new IStatementProcedure(){

            @Override
            public void execute(int s, int p, int o) {
                set[s] = true;
                set[p] = true;
                set[o] = true;
            }
        });
    }

    public TIntHashSet getPredicates() {
        TIntHashSet result = new TIntHashSet();
        this.statements.forEachValue((TObjectProcedure)new TObjectProcedure<TIntObjectHashMap<TIntArrayList>>(result){
            TIntProcedure proc;
            {
                this.proc = new TIntProcedure(){

                    public boolean execute(int value) {
                        tIntHashSet.add(value);
                        return true;
                    }
                };
            }

            public boolean execute(TIntObjectHashMap<TIntArrayList> localStatements) {
                localStatements.forEachKey(this.proc);
                return true;
            }
        });
        return result;
    }

    public int[] toArray() {
        final TIntArrayList statements = new TIntArrayList();
        this.forStatements(new IStatementProcedure(){

            @Override
            public void execute(int s, int p, int o) {
                statements.add(s);
                statements.add(p);
                statements.add(-1);
                statements.add(o);
            }
        });
        return statements.toArray();
    }

    public ArrayList<StatementCollision> getCollisions() {
        ArrayList<StatementCollision> collisions = new ArrayList<StatementCollision>();
        CollisionPredicateProcedure predicateProcedure = new CollisionPredicateProcedure(collisions);
        CollisionSubjectProcedure subjectProcedure = new CollisionSubjectProcedure(predicateProcedure);
        this.statements.forEachEntry((TIntObjectProcedure)subjectProcedure);
        return collisions;
    }

    private static class CollisionPredicateProcedure
    implements TIntObjectProcedure<TIntArrayList> {
        ArrayList<StatementCollision> collisions;
        int subject;

        public CollisionPredicateProcedure(ArrayList<StatementCollision> collisions) {
            this.collisions = collisions;
        }

        public boolean execute(int predicate, TIntArrayList objects) {
            if (objects.size() > 1) {
                objects.sort();
                int oldObject = objects.get(0);
                int collisionCount = 1;
                int i = 1;
                while (i < objects.size()) {
                    int curObject = objects.get(i);
                    if (curObject == oldObject) {
                        ++collisionCount;
                    } else {
                        if (collisionCount > 1) {
                            this.collisions.add(new StatementCollision(this.subject, predicate, oldObject, collisionCount));
                            collisionCount = 1;
                        }
                        oldObject = curObject;
                    }
                    ++i;
                }
                if (collisionCount > 1) {
                    this.collisions.add(new StatementCollision(this.subject, predicate, oldObject, collisionCount));
                }
            }
            return true;
        }
    }

    private static class CollisionSubjectProcedure
    implements TIntObjectProcedure<TIntObjectHashMap<TIntArrayList>> {
        CollisionPredicateProcedure predicateProcedure;

        public CollisionSubjectProcedure(CollisionPredicateProcedure predicateProcedure) {
            this.predicateProcedure = predicateProcedure;
        }

        public boolean execute(int subject, TIntObjectHashMap<TIntArrayList> predicateObjectMap) {
            this.predicateProcedure.subject = subject;
            predicateObjectMap.forEachEntry((TIntObjectProcedure)this.predicateProcedure);
            return true;
        }
    }

    private static class ForStatementsWithSubjectProc
    implements TIntObjectProcedure<TIntArrayList>,
    TIntProcedure {
        int s;
        int p;
        IStatementProcedure proc;

        public ForStatementsWithSubjectProc(int s, IStatementProcedure proc) {
            this.s = s;
            this.proc = proc;
        }

        public boolean execute(int o) {
            this.proc.execute(this.s, this.p, o);
            return true;
        }

        public boolean execute(int p, TIntArrayList b) {
            this.p = p;
            b.forEach((TIntProcedure)this);
            return true;
        }
    }
}

