/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.store;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.IStatementProcedure;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IdRes;
import org.simantics.graph.store.IdentityStore;
import org.simantics.graph.store.StatementStore;
import org.simantics.graph.store.ValueStore;
import org.simantics.graph.utils.GraphExecutor;

public class GraphStore {
    public StatementStore statements;
    public IdentityStore identities;
    public ValueStore values;
    protected THashMap<Class<?>, IStore> stores;

    public GraphStore(StatementStore statements, IdentityStore identities, ValueStore values, THashMap<Class<?>, IStore> stores) {
        this.statements = statements;
        this.identities = identities;
        this.values = values;
        this.stores = stores;
    }

    public GraphStore() {
        this(new StatementStore(), new IdentityStore(), new ValueStore(), new THashMap());
    }

    public GraphStore(GraphStore store) {
        this(store.statements, store.identities, store.values, store.stores);
    }

    public void map(TIntIntHashMap map) {
        ArrayList<IStore.MapTask> tasks = new ArrayList<IStore.MapTask>();
        tasks.add(new IStore.MapTask(this.statements, map));
        tasks.add(new IStore.MapTask(this.values, map));
        for (IStore store : this.stores.values()) {
            tasks.add(new IStore.MapTask(store, map));
        }
        tasks.add(new IStore.MapTask(this.identities, map));
        try {
            GraphExecutor.EXECUTOR.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends IStore> void addStore(Class<T> clazz, T store) {
        this.stores.put(clazz, store);
    }

    public <T extends IStore> T getStore(Class<T> clazz) {
        return (T)((IStore)this.stores.get(clazz));
    }

    public int resToId(Res res) {
        if (res instanceof Path) {
            return this.identities.pathToId((Path)res);
        }
        IdRes idRes = (IdRes)res;
        if (idRes.fragment != this) {
            return -1;
        }
        return idRes.id;
    }

    public int createResToId(Res res) {
        if (res instanceof Path) {
            return this.identities.createPathToId((Path)res);
        }
        IdRes idRes = (IdRes)res;
        if (idRes.fragment != this) {
            throw new RuntimeException("Cannot crate reference to an internal resource of other graph");
        }
        return idRes.id;
    }

    public Res idToRes(int id) {
        Path path = this.identities.idToPath(id);
        if (path == null) {
            return new IdRes(this, id);
        }
        return path;
    }

    public void addIdsToResult(TIntArrayList ids, final Collection<Res> result) {
        ids.forEach(new TIntProcedure(){

            public boolean execute(int value) {
                result.add(GraphStore.this.idToRes(value));
                return true;
            }
        });
    }

    public void collectReferences(boolean[] set) {
        this.statements.collectReferences(set);
        this.identities.collectReferences(set);
        this.values.collectReferences(set);
    }

    public String toString() {
        final StringBuilder b = new StringBuilder();
        this.statements.forStatements(new IStatementProcedure(){

            public String name(int id) {
                Path path = GraphStore.this.identities.idToPath(id);
                if (path == null) {
                    return "(" + id + ")";
                }
                return path + "(" + id + ")";
            }

            @Override
            public void execute(int s, int p, int o) {
                b.append(this.name(s));
                b.append(" ");
                b.append(this.name(p));
                b.append(" ");
                b.append(this.name(o));
                b.append("\n");
            }
        });
        return b.toString();
    }
}

