/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.matching.Stat;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class CanonicalGraph {
    int resourceCount;
    Stat[][] statements;
    TIntIntHashMap inverses = new TIntIntHashMap();
    Identity[] identities;
    String[] names;
    Variant[] values;

    public CanonicalGraph(TransferableGraph1 tg) {
        this.resourceCount = tg.resourceCount;
        this.identities = tg.identities;
        int[] oldStatements = tg.statements;
        ArrayList[] newStatements = new ArrayList[tg.resourceCount];
        int i = 0;
        while (i < newStatements.length) {
            newStatements[i] = new ArrayList(2);
            ++i;
        }
        i = 0;
        while (i < oldStatements.length) {
            int p = oldStatements[i + 1];
            int inv = oldStatements[i + 2];
            if (inv >= 0) {
                this.inverses.put(p, inv);
                this.inverses.put(inv, p);
            }
            i += 4;
        }
        i = 0;
        while (i < oldStatements.length) {
            int s = oldStatements[i];
            int p = oldStatements[i + 1];
            int inv = oldStatements[i + 2];
            int o = oldStatements[i + 3];
            if (inv < 0) {
                if (this.inverses.contains(p)) {
                    inv = this.inverses.get(p);
                } else {
                    inv = this.resourceCount++;
                    this.inverses.put(p, inv);
                    this.inverses.put(inv, p);
                }
            }
            newStatements[s].add(new Stat(p, o));
            newStatements[o].add(new Stat(inv, s));
            i += 4;
        }
        Stat[][] statements = new Stat[this.resourceCount][];
        int i2 = 0;
        while (i2 < tg.resourceCount) {
            int size = newStatements[i2].size();
            statements[i2] = size == 0 ? Stat.NO_STATS : newStatements[i2].toArray(new Stat[size]);
            ++i2;
        }
        i2 = tg.resourceCount;
        while (i2 < this.resourceCount) {
            statements[i2] = Stat.NO_STATS;
            ++i2;
        }
        this.statements = statements;
        Variant[] values = new Variant[this.resourceCount];
        Value[] valueArray = tg.values;
        int n = tg.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            values[value.resource] = value.value;
            ++n2;
        }
        this.values = values;
    }
}

