package org.simantics.graph.query;



public class Paths {
    public static PathRoot  Root = new PathRoot("");
	public static Path SimanticsDomain = Root.child("www.simantics.org");
	
	public Path Layer0;
	
	public Path InstanceOf;
	public Path Inherits;
	public Path SupertypeOf;
	public Path SubrelationOf;
	public Path SuperrelationOf;
	public Path InverseOf;
	public Path HasDatatype;
	public Path Asserts;
	public Path Assertion;
	public Path HasPredicate;
	public Path HasObject;
	public Path Equals;
	public Path ConsistsOf;
	public Path PartOf;
	public Path HasNext;
	public Path HasPrevious;	
	public Path Template;
	public Path HasTemplate;
	public Path HasTemplateParameters;
	public Path HasCardinality;	
	public Path PropertyDefinition;
	public Path HasPropertyDefinition;
	public Path ConcernsRelation;
	public Path HasDomain;
	public Path HasRange;
	public Path Tag;
	public Path Entity;
	public Path IsWeaklyRelatedTo;
	public Path IsRelatedTo;
	
	public Path HasResourceClass;
	public Path Deprecated;
	
	public Path Library;
	
	// Literal types
	public Path Literal;
	public Path Boolean;
	public Path Byte;
	public Path Integer;
	public Path Long;
	public Path Float;
	public Path Double;
	public Path String;	
	public Path Variant;
	
	public Path BooleanArray;
	public Path ByteArray;
	public Path IntegerArray;
	public Path LongArray;
	public Path FloatArray;
	public Path DoubleArray;
	public Path StringArray;
	
	public Path Graph;
	public Path Datatype;
	public Path IntegerRange;
	
	public Path List;
	public Path List_Entry;
	public Path List_Next;
	public Path List_Previous;
	public Path List_Element;
	
	public Paths(String layer0Version) {
	    Layer0 = SimanticsDomain.child("Layer0-" + layer0Version);
	    
	    InstanceOf = Layer0.child("InstanceOf");
	    Inherits = Layer0.child("Inherits");
	    SupertypeOf = Layer0.child("SupertypeOf");
	    SubrelationOf = Layer0.child("SubrelationOf");
	    SuperrelationOf = Layer0.child("SuperrelationOf");
	    InverseOf = Layer0.child("InverseOf");
	    HasDatatype = Layer0.child("HasDataType");
	    Asserts = Layer0.child("Asserts");
	    Assertion = Layer0.child("Assertion");
	    HasPredicate = Layer0.child("HasPredicate");
	    HasObject = Layer0.child("HasObject");
	    Equals = Layer0.child("Equals");
	    ConsistsOf = Layer0.child("ConsistsOf");
	    PartOf = Layer0.child("PartOf");
	    HasNext = Layer0.child("HasNext");
	    HasPrevious = Layer0.child("HasPrevious");  
	    Template = Layer0.child("Template");
	    HasTemplate = Layer0.child("HasTemplate");
	    HasTemplateParameters = Layer0.child("HasTemplateParameters");
	    HasCardinality = Layer0.child("HasCardinality");    
	    PropertyDefinition = Layer0.child("PropertyDefinition");
	    HasPropertyDefinition = Layer0.child("HasPropertyDefinition");
	    ConcernsRelation = Layer0.child("ConcernsRelation");
	    HasDomain = Layer0.child("HasDomain");
	    HasRange = Layer0.child("HasRange");
	    Tag = Layer0.child("Tag");
	    Entity = Layer0.child("Entity");
	    IsWeaklyRelatedTo = Layer0.child("IsWeaklyRelatedTo");
	    IsRelatedTo = Layer0.child("IsRelatedTo");
	    
	    HasResourceClass = Layer0.child("HasResourceClass");
	    Deprecated = Layer0.child("Deprecated");
	    
	    Library = Layer0.child("Library");
	    
	    // Literal types
	    Literal = Layer0.child("Literal");
	    Boolean = Layer0.child("Boolean");
	    Byte = Layer0.child("Byte");
	    Integer = Layer0.child("Integer");
	    Long = Layer0.child("Long");
	    Float = Layer0.child("Float");
	    Double = Layer0.child("Double");
	    String = Layer0.child("String");    
	    Variant = Layer0.child("Variant");
	    
	    BooleanArray = Layer0.child("BooleanArray");
	    ByteArray = Layer0.child("ByteArray");
	    IntegerArray = Layer0.child("IntegerArray");
	    LongArray = Layer0.child("LongArray");
	    FloatArray = Layer0.child("FloatArray");
	    DoubleArray = Layer0.child("DoubleArray");
	    StringArray = Layer0.child("StringArray");
	    
	    Graph = Layer0.child("Graph");
	    Datatype = Layer0.child("DataType");
	    IntegerRange = Layer0.child("IntegerRange");
	    
	    List = Layer0.child("List");
	    List_Entry = List.child("Entry");
	    List_Next = List.child("Next");
	    List_Previous = List.child("Previous");
	    List_Element = List.child("Element");	    
	}
	
	public Path getPath(String url) {
		String[] parts = url.split("/{1,2}");
		if ( parts.length == 0 ) return null;
		Path path = parts[0].equals("http:") ? Root : new PathRoot(parts[0]);
		for (int i=1; i<parts.length; i++) {
			path = path.child( parts[i] );
		}
		return path;
	}

}
