package org.simantics.graph.compiler.internal.procedures;

import java.util.Arrays;
import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.BuiltinTemplates;
import org.simantics.graph.compiler.internal.templates.GraphTemplate;
import org.simantics.graph.compiler.internal.templates.ITemplate;
import org.simantics.graph.compiler.internal.templates.TemplateInstanceStore;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;

import gnu.trove.map.hash.TIntObjectHashMap;

public class ApplyTemplates implements Runnable {
	IGraph graph;
	GraphStore store;
	Collection<Problem> problems;
	ExternalFileLoader fileLoader;	
	BuiltinTemplates builtinTemplates;
	
	public ApplyTemplates(IGraph graph, GraphStore store,
			Collection<Problem> problems, ExternalFileLoader fileLoader) {
		this.graph = graph;
		this.store = store;
		this.problems = problems;	
		this.fileLoader = fileLoader;
		this.builtinTemplates = new BuiltinTemplates(graph.getPaths());
	}

	TIntObjectHashMap<ITemplate> cache = new TIntObjectHashMap<ITemplate>(); 	
	
	ITemplate getTemplate(int id) {
		ITemplate template = cache.get(id);
		if(template == null) {
			template = createTemplate(id);
			cache.put(id, template);
		}
		return template;
	}
	
	ITemplate createTemplate(int id) {
		Res res = store.idToRes(id);
		if(res instanceof Path) {
			ITemplate template = builtinTemplates.TEMPLATES.get((Path)res);
			if(template != null)
				return template;
		}

		Paths paths = graph.getPaths();		        
		try {			
			Res template = graph.singleRawObject(res, paths.HasTemplate);
			TransferableGraph1 tg = (TransferableGraph1)
			        graph.getValue(template, TransferableGraph1.BINDING);
			
			Res templateParameters = graph.singleRawObject(res, paths.HasTemplateParameters);
			String[] parameters = (String[])graph.getValue(templateParameters).getValue(Bindings.STRING_ARRAY);
			
			return new GraphTemplate(store, parameters, tg);
		} catch(Exception e) {
			//e.printStackTrace();
			Location location = store.getStore(LocationStore.class)
				.getLocation(id);
			problems.add(new Problem(
					location, e.getMessage()));
			return null;
		}
	}

	@Override
	public void run() {
		TemplateInstanceStore templateStore = store.getStore(TemplateInstanceStore.class);
		if(templateStore == null)
			return;
		
		for(int[] inst : templateStore.getTemplateInstances()) {
			ITemplate template = getTemplate(inst[0]);
			if(template != null)
				template.apply(graph, store, Arrays.copyOfRange(inst, 1, inst.length), fileLoader, problems);
		}
	}	
}
