/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils.geom;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.simantics.g2d.utils.GeometryUtils;

public class DirectionSet
extends HashSet<Double> {
    public static final DirectionSet NESW = new DirectionSet(0.0, 90.0, 180.0, 270.0);
    public static final DirectionSet N = new DirectionSet(0.0);
    public static final DirectionSet NE = new DirectionSet(0.0, 90.0);
    public static final DirectionSet E = new DirectionSet(90.0);
    public static final DirectionSet SE = new DirectionSet(90.0, 180.0);
    public static final DirectionSet S = new DirectionSet(180.0);
    public static final DirectionSet SW = new DirectionSet(180.0, 270.0);
    public static final DirectionSet W = new DirectionSet(270.0);
    public static final DirectionSet NW = new DirectionSet(270.0, 0.0);
    public static final DirectionSet NE2 = new DirectionSet(0.0, 90.0, 45.0);
    public static final DirectionSet SE2 = new DirectionSet(90.0, 180.0, 135.0);
    public static final DirectionSet SW2 = new DirectionSet(180.0, 270.0, 225.0);
    public static final DirectionSet NW2 = new DirectionSet(270.0, 0.0, 315.0);
    public static final DirectionSet HORIZ = new DirectionSet(90.0, 270.0);
    public static final DirectionSet VERT = new DirectionSet(0.0, 180.0);
    public static final DirectionSet ANY = new DirectionSet(0.0, 15.0, 30.0, 45.0, 60.0, 75.0, 90.0, 105.0, 120.0, 135.0, 150.0, 165.0, 180.0, 195.0, 210.0, 225.0, 240.0, 255.0, 270.0, 285.0, 300.0, 315.0, 330.0, 345.0);
    private Set<Point2D> unitVectors;
    private static final long serialVersionUID = 1L;

    public DirectionSet(double ... directions) {
        double[] dArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            this.add(d);
            ++n2;
        }
    }

    @Override
    private boolean add(double e) {
        if (e < 0.0 || e >= 360.0) {
            e = Math.IEEEremainder(e, 360.0);
        }
        if (e < 0.0) {
            e = 360.0 - e;
        }
        return super.add(e);
    }

    @Override
    public boolean add(Double e) {
        this.unitVectors = null;
        if (e == null) {
            return false;
        }
        return this.add((double)e);
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        this.unitVectors = null;
        return super.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        this.unitVectors = null;
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.unitVectors = null;
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        this.unitVectors = null;
        super.clear();
    }

    public Double getClosestDirection(double d2) {
        Double closest = null;
        for (Double d1 : this) {
            double diff;
            double d = d1 > 180.0 == d2 > 180.0 ? Math.abs(d1 - d2) : (diff = d1 < d2 ? d1 - d2 + 360.0 : d2 - d1 + 360.0);
            if (closest != null && !(closest < diff)) continue;
            closest = diff;
        }
        return closest;
    }

    public Double getClosestDirection(double d2, double tolerance) {
        Double closest = null;
        for (Double d1 : this) {
            double diff;
            double d = d1 > 180.0 == d2 > 180.0 ? Math.abs(d1 - d2) : (diff = d1 < d2 ? d1 - d2 + 360.0 : d2 - d1 + 360.0);
            if (diff > tolerance || closest != null && !(closest < diff)) continue;
            closest = diff;
        }
        return closest;
    }

    public DirectionSet createInverse() {
        DirectionSet result = new DirectionSet(new double[0]);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            double dir = (Double)iterator.next();
            if ((dir += 180.0) > 360.0) {
                dir -= 360.0;
            }
            result.add(dir);
        }
        return result;
    }

    private Set<Point2D> createUnitVectors() {
        HashSet<Point2D> result = new HashSet<Point2D>(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            result.add(GeometryUtils.toUnitVector(d, new Point2D.Double()));
        }
        return result;
    }

    public Set<Point2D> getUnitVectors() {
        if (this.unitVectors == null) {
            this.unitVectors = this.createUnitVectors();
            this.unitVectors = Collections.unmodifiableSet(this.unitVectors);
        }
        return this.unitVectors;
    }
}

