/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.svg;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class SVGImage
implements Image {
    static EnumSet<Image.Feature> caps = EnumSet.of(Image.Feature.Vector);
    private Rectangle2D bounds;
    protected final String nodeIdentifier;
    protected final String svgDocument;
    protected Point targetSize;

    public static SVGImage loadFromURL(String nodeIdentifier, URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = url.openStream();){
            return new SVGImage(nodeIdentifier, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument) {
        return SVGImage.createFactoryFromString(svgDocument, null);
    }

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument, Point targetSize) {
        return new SVGFactory(nodeIdentifier, svgDocument, targetSize);
    }

    public SVGImage(String nodeIdentifier, String svgDocument) {
        this(nodeIdentifier, svgDocument, null);
    }

    public SVGImage(String nodeIdentifier, String svgDocument, Point targetSize) {
        if (nodeIdentifier == null) {
            throw new NullPointerException("nodeIdentifier is null");
        }
        if (svgDocument == null) {
            throw new NullPointerException("svgDocument is null");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.svgDocument = svgDocument;
        this.targetSize = targetSize;
    }

    public SVGImage(String nodeIdentifier, InputStream svgInput) {
        if (nodeIdentifier == null) {
            throw new NullPointerException("nodeIdentifier is null");
        }
        String data = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(svgInput, "UTF-8"));
            String line = "";
            while ((line = reader.readLine()) != null) {
                data = String.valueOf(data) + line + "\n";
            }
        }
        catch (IOException iOException) {}
        this.nodeIdentifier = nodeIdentifier;
        this.bounds = SVGNode.getBounds((String)data);
        this.svgDocument = data;
    }

    @Override
    public Node init(G2DParentNode parent) {
        SVGNode node = (SVGNode)parent.getOrCreateNode(this.nodeIdentifier, SVGNode.class);
        node.setData(this.svgDocument);
        node.setTargetSize(this.targetSize);
        node.useMipMap(Boolean.valueOf(true));
        return node;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = SVGNode.getBounds((String)this.svgDocument);
        }
        return this.bounds;
    }

    @Override
    public Shape getOutline() {
        return this.getBounds();
    }

    @Override
    public void addImageListener(Image.ImageListener listener) {
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return caps;
    }

    @Override
    public void removeImageListener(Image.ImageListener listener) {
    }

    static class SVGFactory
    implements IFactory<Image> {
        String nodeIdentifier;
        String document;
        Point targetSize;

        public SVGFactory(String nodeIdentifier, String document) {
            this(nodeIdentifier, document, null);
        }

        public SVGFactory(String nodeIdentifier, String document, Point referenceSize) {
            if (nodeIdentifier == null) {
                throw new NullPointerException("nodeIdentifier is null");
            }
            if (document == null) {
                throw new NullPointerException("document is null");
            }
            this.nodeIdentifier = nodeIdentifier;
            this.document = document;
            this.targetSize = referenceSize;
        }

        public Image get() throws ProvisionException {
            return new SVGImage(this.nodeIdentifier, this.document, this.targetSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            SVGFactory other = (SVGFactory)obj;
            if (!this.nodeIdentifier.equals(other.nodeIdentifier)) {
                return false;
            }
            if (this.targetSize != null ? !this.targetSize.equals(other.targetSize) : other.targetSize != null) {
                return false;
            }
            return this.document.equals(other.document);
        }

        public int hashCode() {
            return this.nodeIdentifier.hashCode() * 31 + this.document.hashCode() + 123;
        }
    }
}

