/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Map;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.InstancingShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class PointerPainter
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_PAINT_POINTER = new IHintContext.KeyOf(Boolean.class);
    public static final int CURSOR_PAINT_Z_ORDER = 5000;
    private static final Stroke CURSOR_STROKE = new BasicStroke(1.0f);
    @DependencyReflection.Dependency
    MouseUtil monitor;
    InstancingShapeNode node;
    Shape pointer;

    public PointerPainter() {
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(-10.0, -10.0);
        ((Path2D)p).lineTo(10.0, 10.0);
        ((Path2D)p).moveTo(10.0, -10.0);
        ((Path2D)p).lineTo(-10.0, 10.0);
        this.pointer = p;
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void init(G2DParentNode parent) {
        this.node = (InstancingShapeNode)parent.addNode("pointers", InstancingShapeNode.class);
        this.node.setZIndex(5000);
        this.node.setShape(this.pointer);
        this.node.setStroke(CURSOR_STROKE);
        this.node.setFill(false);
        this.node.setScaleStroke(false);
        this.node.setScaleShape(false);
    }

    @SGNodeReflection.SGCleanup
    public void cleanup() {
        this.node.remove();
        this.node = null;
    }

    public boolean isCursorEnabled() {
        Boolean pp = (Boolean)this.getHint(KEY_PAINT_POINTER);
        return Boolean.TRUE.equals(pp);
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleMouseEvent(MouseEvent e) {
        if (!this.isCursorEnabled()) {
            return false;
        }
        this.assertDependencies();
        if (e instanceof MouseEvent.MouseMovedEvent || e instanceof MouseEvent.MouseButtonPressedEvent || e instanceof MouseEvent.MouseButtonReleasedEvent) {
            this.updateNode();
            this.setDirty();
        }
        return false;
    }

    private void updateNode() {
        Map<Integer, MouseUtil.MouseInfo> miceInfo = this.monitor.getMiceInfo();
        AffineTransform[] transforms = new AffineTransform[miceInfo.size()];
        Paint[] paints = new Paint[miceInfo.size()];
        int i = 0;
        for (MouseUtil.MouseInfo mi : miceInfo.values()) {
            int color = 0;
            if ((mi.buttons & 1) > 0) {
                color |= 0xFF;
            }
            if ((mi.buttons & 2) > 0) {
                color |= 0xFF00;
            }
            if ((mi.buttons & 4) > 0) {
                color |= 0xFF0000;
            }
            transforms[i] = AffineTransform.getTranslateInstance(mi.controlPosition.getX(), mi.controlPosition.getY());
            paints[i] = new Color(color);
            ++i;
        }
        this.node.setInstances(transforms, paints);
    }
}

