/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.StaticProvider;

public class PaintableSymbolHandler
implements SceneGraph,
Pick,
InternalSize {
    private static final long serialVersionUID = 8612101011132309291L;
    private final Rectangle2D rect;
    private final Double ratio;
    private final Image ps;
    private final IProvider<Image> symbolProvider;

    public PaintableSymbolHandler(Image symbol) {
        this.symbolProvider = StaticProvider.provide((Object)symbol);
        this.ps = (Image)this.symbolProvider.get();
        this.rect = this.ps.getBounds();
        this.ratio = this.rect.getWidth() / this.rect.getHeight();
    }

    public PaintableSymbolHandler(IProvider<Image> symbolProvider) {
        this.symbolProvider = symbolProvider;
        this.ps = (Image)symbolProvider.get();
        this.rect = this.ps.getBounds();
        this.ratio = this.rect.getWidth() / this.rect.getHeight();
    }

    @Override
    public void cleanup(IElement e) {
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        System.out.println("PaintableSymbolHandler.paint()");
    }

    @Override
    public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
        Shape outline = this.ps.getOutline();
        if (policy == PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS) {
            return GeometryUtils.contains(s, outline);
        }
        if (policy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS) {
            return GeometryUtils.intersects(s, outline);
        }
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        size.setFrame(this.rect);
        return size;
    }
}

