/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Togglable;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public abstract class ResizeableImagePaint
implements SceneGraph {
    private static final long serialVersionUID = 5955540004168283683L;
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "RESIZABLE_IMAGE_SG_NODE");

    @Override
    public void init(final IElement e, G2DParentNode parent) {
        System.out.println("ResizeableImagePaint.init");
        Togglable togglable = e.getElementClass().getAtMostOneItemOfClass(Togglable.class);
        boolean toggled = false;
        if (togglable != null) {
            toggled = togglable.isChecked(e);
        }
        Clickable.PressStatus status = null;
        e.getElementClass().getAtMostOneItemOfClass(Clickable.class);
        status = Clickable.PressStatus.NORMAL;
        Image image = this.getImage(status, toggled);
        Node node = (Node)e.getHint(KEY_SG_NODE);
        if (node != null) {
            node.remove();
        }
        node = image.init(parent);
        e.setHint(KEY_SG_NODE, node);
        e.addHintListener(new IHintListener(){

            public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            }

            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                Rectangle2D size;
                G2DNode node;
                if (key == ElementHints.KEY_TRANSFORM) {
                    node = (G2DNode)e.getHint(KEY_SG_NODE);
                    size = (Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS);
                    AffineTransform at = (AffineTransform)newValue;
                    AffineTransform at2 = node.getTransform();
                    node.setTransform(new AffineTransform(at2.getScaleX(), at2.getShearX(), at2.getShearY(), at2.getScaleY(), at.getTranslateX() + size.getWidth() * 0.5, at.getTranslateY() + size.getHeight() * 0.5));
                }
                if (key == ElementHints.KEY_BOUNDS) {
                    node = (G2DNode)e.getHint(KEY_SG_NODE);
                    size = (Rectangle2D)newValue;
                    Rectangle2D bounds = node.getBoundsInLocal();
                    AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
                    node.setTransform(new AffineTransform(size.getWidth() / bounds.getWidth(), 0.0, 0.0, size.getHeight() / bounds.getHeight(), at.getTranslateX() + size.getWidth() * 0.5, at.getTranslateY() + size.getHeight() * 0.5));
                }
            }
        });
    }

    @Override
    public void cleanup(IElement e) {
        Node node = (Node)e.getHint(KEY_SG_NODE);
        if (node != null) {
            node.remove();
        }
    }

    public abstract Image getImage(Clickable.PressStatus var1, boolean var2);
}

