/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class Selection
extends AbstractCanvasParticipant {
    public static final SelectionHintKey SELECTION0 = new SelectionHintKey(0);
    private static final Set<IElement> NO_SELECTION = Collections.unmodifiableSet(new HashSet(0));

    public static SelectionHintKey getKeyForSelectionId(int selectionId) {
        if (selectionId == 0) {
            return SELECTION0;
        }
        return new SelectionHintKey(selectionId);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent e) {
        if (e.command.equals((Object)Commands.SELECT_ALL)) {
            IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
            if (d == null) {
                return true;
            }
            this.addAll(0, d.getElements());
            return true;
        }
        if (e.command.equals((Object)Commands.INVERT_SELECTION)) {
            IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
            if (d == null) {
                return true;
            }
            Set<IElement> current = this.getSelection(0);
            HashSet<IElement> inverted = new HashSet<IElement>(d.getElements());
            inverted.removeAll(current);
            this.setSelection(0, inverted);
            return true;
        }
        return false;
    }

    public Set<IElement> getSelection(int selectionId) {
        SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
        Set selection = (Set)this.getHint((IHintContext.Key)key);
        if (selection == null) {
            return NO_SELECTION;
        }
        return new HashSet<IElement>(selection);
    }

    public Set<IElement> getAllSelections() {
        HashSet<IElement> result = new HashSet<IElement>();
        for (Map.Entry entry : this.getContext().getHintStack().getHintsOfClass(SelectionHintKey.class).entrySet()) {
            Set set = (Set)entry.getValue();
            if (set == null || set.isEmpty()) continue;
            result.addAll(set);
        }
        return result;
    }

    public Map<Integer, Set<IElement>> getSelections() {
        HashMap<Integer, Set<IElement>> result = new HashMap<Integer, Set<IElement>>();
        for (Map.Entry entry : this.getContext().getHintStack().getHintsOfClass(SelectionHintKey.class).entrySet()) {
            Set set = (Set)entry.getValue();
            if (set == null || set.isEmpty()) continue;
            result.put(((SelectionHintKey)((Object)entry.getKey())).mouseId, set);
        }
        return result;
    }

    public int[] getSelectionIds() {
        Map map = this.getContext().getHintStack().getHintsOfClass(SelectionHintKey.class);
        int[] result = new int[map.size()];
        int i = 0;
        for (SelectionHintKey key : map.keySet()) {
            result[i++] = key.mouseId;
        }
        return result;
    }

    public boolean setSelection(final int selectionId, final Collection<IElement> _selection) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Set<IElement> oldSelection;
                Set<IElement> selection = _selection;
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                if (selection == null || selection.isEmpty()) {
                    selection = NO_SELECTION;
                }
                if ((oldSelection = (Set<IElement>)Selection.this.getHint((IHintContext.Key)key)) == null) {
                    oldSelection = NO_SELECTION;
                }
                if (oldSelection.equals(selection)) {
                    return;
                }
                if (selection == NO_SELECTION) {
                    Selection.this.removeHint((IHintContext.Key)key);
                    result.set((Object)true);
                }
                Set<IElement> newSelection = Collections.unmodifiableSet(new HashSet<IElement>(selection));
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public boolean setSelection(int selectionId, IElement selection) {
        ArrayList<IElement> list = new ArrayList<IElement>(1);
        list.add(selection);
        return this.setSelection(selectionId, list);
    }

    public boolean add(final int selectionId, final IElement pickable) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> oldSelection = Selection.this.getSelection(selectionId);
                if (oldSelection.contains(pickable)) {
                    return;
                }
                Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
                newSelection.add(pickable);
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public boolean addAll(final int selectionId, final Collection<IElement> pickables) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> selection = Selection.this.getSelection(selectionId);
                if (selection.containsAll(pickables)) {
                    return;
                }
                Set<IElement> newSelection = new HashSet<IElement>(selection);
                newSelection.addAll(pickables);
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public boolean remove(final int selectionId, final IElement pickable) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> oldSelection = Selection.this.getSelection(selectionId);
                if (!oldSelection.contains(pickable)) {
                    return;
                }
                Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
                newSelection.remove(pickable);
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public static boolean containsAny(Collection<?> x, Collection<?> y) {
        for (Object o : x) {
            if (!y.contains(o)) continue;
            return true;
        }
        return false;
    }

    public boolean removeAll(final int selectionId, final Collection<IElement> pickables) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> oldSelection = Selection.this.getSelection(selectionId);
                if (!Selection.containsAny(oldSelection, pickables)) {
                    return;
                }
                Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
                newSelection.removeAll(pickables);
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public boolean retainAll(final int selectionId, final Collection<IElement> pickable) {
        final DataContainer result = new DataContainer((Object)false);
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> oldSelection = Selection.this.getSelection(selectionId);
                Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
                newSelection.retainAll(pickable);
                if (oldSelection.equals(newSelection)) {
                    return;
                }
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public boolean contains(int selectionId, IElement pickable) {
        Set<IElement> oldSelection = this.getSelection(selectionId);
        return oldSelection.contains(pickable);
    }

    public synchronized void toggle(final int selectionId, final Set<IElement> toggleSet) {
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
                Set<IElement> oldSelection = Selection.this.getSelection(selectionId);
                Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
                CollectionUtils.toggle(newSelection, (Set)toggleSet);
                newSelection = Collections.unmodifiableSet(newSelection);
                Selection.this.setHint((IHintContext.Key)key, newSelection);
            }
        });
    }

    public synchronized void toggle(int selectionId, IElement pickable) {
        SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
        Set<IElement> oldSelection = this.getSelection(selectionId);
        Set<IElement> newSelection = new HashSet<IElement>(oldSelection);
        if (oldSelection.contains(pickable)) {
            newSelection.remove(pickable);
        } else {
            newSelection.add(pickable);
        }
        newSelection = Collections.unmodifiableSet(newSelection);
        this.setHint((IHintContext.Key)key, newSelection);
    }

    public void clear(int selectionId) {
        SelectionHintKey key = Selection.getKeyForSelectionId(selectionId);
        this.removeHint((IHintContext.Key)key);
    }

    public static class SelectionHintKey
    extends IHintContext.MouseSpecificKeyOf {
        public SelectionHintKey(int mouseId) {
            super(mouseId, Set.class);
        }
    }
}

