/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.layout;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.LayoutManager;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.hints.IHintContext;

public class FlowLayout
implements LayoutManager {
    public static final IHintContext.Key ALIGN = new IHintContext.KeyOf(Align.class, "FlowLayout.ALIGN");
    public static final IHintContext.Key HGAP = new IHintContext.KeyOf(Double.class, "FlowLayout.HGAP");
    public static final IHintContext.Key VGAP = new IHintContext.KeyOf(Double.class, "FlowLayout.VGAP");

    @Override
    public void layout(IDiagram diagram, Rectangle2D bounds) {
        Align align = (Align)((Object)diagram.getHint(ALIGN));
        Double hgap = (Double)diagram.getHint(HGAP);
        Double vgap = (Double)diagram.getHint(VGAP);
        if (align == null) {
            align = Align.Left;
        }
        if (hgap == null) {
            hgap = 0.0;
        }
        if (vgap == null) {
            vgap = 0.0;
        }
        Map<IElement, Rectangle2D> pos = this.computePositions(diagram, bounds, align, hgap, vgap);
        for (Map.Entry<IElement, Rectangle2D> e : pos.entrySet()) {
            ElementUtils.setPos(e.getKey(), e.getValue().getMinX(), e.getValue().getMinY());
        }
    }

    @Override
    public Rectangle2D computeSize(IDiagram diagram, Double wHint, Double hHint) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        Align align = (Align)((Object)diagram.getHint(ALIGN));
        Double hgap = (Double)diagram.getHint(HGAP);
        Double vgap = (Double)diagram.getHint(VGAP);
        if (align == null) {
            align = Align.Left;
        }
        if (hgap == null) {
            hgap = 0.0;
        }
        if (vgap == null) {
            vgap = 0.0;
        }
        if (wHint == null) {
            wHint = Double.MAX_VALUE;
        }
        if (hHint == null) {
            hHint = Double.MAX_VALUE;
        }
        bounds.setFrame(0.0, 0.0, wHint, hHint);
        Map<IElement, Rectangle2D> pos = this.computePositions(diagram, bounds, align, hgap, vgap);
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (IElement e : pos.keySet()) {
            Rectangle2D b = pos.get(e);
            if (b.getMinX() < minX) {
                minX = b.getMinX();
            }
            if (b.getMinY() < minY) {
                minY = b.getMinY();
            }
            if (b.getMaxX() > maxX) {
                maxX = b.getMaxX();
            }
            if (!(b.getMaxY() > maxY)) continue;
            maxY = b.getMaxY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private Map<IElement, Rectangle2D> computePositions(IDiagram diagram, Rectangle2D bounds, Align align, double hgap, double vgap) {
        double width = bounds.getWidth();
        List<IElement> elements = diagram.getSnapshot();
        Map<IElement, Rectangle2D> rects = ElementUtils.getElementBoundsOnDiagram(elements, null);
        ArrayList rows = new ArrayList();
        ArrayList<IElement> row = new ArrayList<IElement>();
        rows.add(row);
        double rowWidth = 0.0;
        for (IElement e : elements) {
            Rectangle2D elementBounds = rects.get(e);
            if (row.isEmpty()) {
                row.add(e);
                rowWidth += elementBounds.getWidth();
                continue;
            }
            if (rowWidth + elementBounds.getWidth() + hgap * (double)row.size() < width) {
                rowWidth += elementBounds.getWidth();
                row.add(e);
                continue;
            }
            row = new ArrayList();
            rows.add(row);
            row.add(e);
            rowWidth = elementBounds.getWidth();
        }
        double y = bounds.getMinY();
        double hmargin = hgap;
        for (List list : rows) {
            double rowHeight = 0.0;
            double rowContentWidth = (double)(row.size() - 1) * hgap;
            for (IElement e : row) {
                rowContentWidth += rects.get(e).getWidth();
            }
            double x = hgap + bounds.getMinX();
            double _hgap = hgap;
            if (align == Align.Center) {
                x = (width - hmargin - hmargin - rowContentWidth) / 2.0;
            }
            if (align == Align.Left) {
                x = hmargin;
            }
            if (align == Align.Right) {
                x = width - rowContentWidth - hmargin;
            }
            if (align == Align.Fill) {
                x = hmargin;
                _hgap = (width - hmargin - hmargin - rowContentWidth) / (double)(row.size() + 1);
            }
            for (IElement e : list) {
                Rectangle2D rect = rects.get(e);
                rect.setFrame(x, y, rect.getWidth(), rect.getHeight());
                x += rect.getWidth() + _hgap;
                rowHeight = Math.max(rowHeight, rect.getHeight());
            }
            x = bounds.getMinX();
            y += rowHeight + vgap;
        }
        return rects;
    }

    public static enum Align {
        Left,
        Center,
        Right,
        Fill;

    }
}

