/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.MouseCaptureContext;
import org.simantics.g2d.canvas.impl.MouseCursorContext;
import org.simantics.g2d.canvas.impl.PaintableContextImpl;
import org.simantics.g2d.chassis.ITooltipProvider;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerStack;
import org.simantics.scenegraph.g2d.events.EventQueue;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.MouseEventCoalescer;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.utils.datastructures.context.Context;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintStack;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class CanvasContext
extends Context<ICanvasParticipant>
implements ICanvasContext {
    protected HintStack hintStack = new HintStack();
    protected HintContext bottomHintContext = new HintContext();
    protected IEventHandlerStack eventHandlerStack = null;
    protected boolean eventHandlingOrdered = false;
    protected EventQueue eventQueue = null;
    protected IContentContext paintableCtx = new PaintableContextImpl();
    protected final IThreadWorkQueue thread;
    protected IMouseCaptureContext mouseCaptureCtx = new MouseCaptureContext();
    protected IMouseCursorContext mouseCursorCtx = new MouseCursorContext();
    protected G2DSceneGraph sceneGraph;
    protected G2DParentNode canvasNode = null;
    protected ITooltipProvider tooltip;
    protected final AtomicBoolean locked = new AtomicBoolean(false);
    private final Runnable eventHandling = new Runnable(){

        @Override
        public void run() {
            if (!CanvasContext.this.isAlive()) {
                return;
            }
            CanvasContext.this.eventHandlingOrdered = false;
            CanvasContext.this.eventQueue.handleEvents();
        }
    };

    public CanvasContext(IThreadWorkQueue thread) {
        this(thread, new G2DSceneGraph());
    }

    public CanvasContext(IThreadWorkQueue thread, G2DSceneGraph sg) {
        super(ICanvasParticipant.class);
        if (thread == null) {
            throw new IllegalArgumentException("null");
        }
        this.sceneGraph = sg;
        this.canvasNode = (G2DParentNode)sg.addNode("navigation", G2DParentNode.class);
        this.canvasNode.setLookupId("navigation");
        DataNode dataNode = (DataNode)sg.addNode("data", DataNode.class);
        dataNode.setLookupId("data");
        this.thread = thread;
        this.eventHandlerStack = new EventHandlerStack(thread);
        this.eventQueue = new EventQueue((IEventHandler)this.eventHandlerStack);
        this.hintStack.addHintContext((IHintContext)this.bottomHintContext, Integer.MIN_VALUE);
        this.eventHandlerStack.add((Object)this.sceneGraph.getEventHandler(), 0x100000);
        this.addContextListener(thread, (IContextListener)new IContextListener<ICanvasParticipant>(){

            public void itemAdded(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
                item.addedToContext(CanvasContext.this);
            }

            public void itemRemoved(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
                item.removedFromContext(CanvasContext.this);
            }
        });
        this.eventQueue.addEventCoalesceler((IEventQueue.EventCoalescer)MouseEventCoalescer.INSTANCE);
        this.eventQueue.addQueueListener(new IEventQueue.IEventQueueListener(){

            public void onEventAdded(IEventQueue queue, Event e, int index) {
                CanvasContext.this.asyncHandleEvents();
            }

            public void onQueueEmpty(IEventQueue queue) {
            }
        });
    }

    @Override
    public IHintStack getHintStack() {
        this.assertNotDisposed();
        return this.hintStack;
    }

    synchronized void asyncHandleEvents() {
        if (this.eventHandlingOrdered) {
            return;
        }
        this.eventHandlingOrdered = true;
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)this.eventHandling);
    }

    synchronized void syncHandleEvents() {
        if (this.eventHandlingOrdered) {
            return;
        }
        this.eventHandlingOrdered = true;
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)this.eventHandling);
    }

    @Override
    public G2DSceneGraph getSceneGraph() {
        return this.sceneGraph;
    }

    @Override
    public void setCanvasNode(G2DParentNode node) {
        this.canvasNode = node;
    }

    @Override
    public G2DParentNode getCanvasNode() {
        return this.canvasNode;
    }

    @Override
    public IEventHandlerStack getEventHandlerStack() {
        this.assertNotDisposed();
        return this.eventHandlerStack;
    }

    @Override
    public IThreadWorkQueue getThreadAccess() {
        return this.thread;
    }

    protected void doDispose() {
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CanvasContext.this.clear();
                CanvasContext.this.bottomHintContext.clearWithoutNotification();
                if (CanvasContext.this.sceneGraph != null) {
                    CanvasContext.this.sceneGraph.removeNodes();
                    CanvasContext.this.sceneGraph.cleanup();
                    CanvasContext.this.sceneGraph = null;
                }
                CanvasContext.this.eventHandlerStack = null;
                CanvasContext.this.hintStack = null;
                CanvasContext.this.canvasNode.cleanup();
                CanvasContext.this.canvasNode = null;
                CanvasContext.this.eventQueue = null;
                CanvasContext.this.mouseCaptureCtx = null;
                CanvasContext.this.mouseCursorCtx = null;
                CanvasContext.this.paintableCtx = null;
                CanvasContext.this.listeners.clear();
                CanvasContext.this.listeners = null;
                CanvasContext.this.set.clear();
                CanvasContext.this.set = null;
                CanvasContext.this.tooltip = null;
            }
        });
    }

    @Override
    public IHintContext getDefaultHintContext() {
        return this.bottomHintContext;
    }

    @Override
    public IMouseCursorContext getMouseCursorContext() {
        return this.mouseCursorCtx;
    }

    @Override
    public void setMouseCursorContext(IMouseCursorContext ctx) {
        this.mouseCursorCtx = ctx;
    }

    @Override
    public IMouseCaptureContext getMouseCaptureContext() {
        return this.mouseCaptureCtx;
    }

    @Override
    public void setMouseCaptureContext(IMouseCaptureContext mctx) {
        this.mouseCaptureCtx = mctx;
    }

    @Override
    public ITooltipProvider getTooltipProvider() {
        return this.tooltip;
    }

    @Override
    public void setTooltipProvider(ITooltipProvider tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public IEventQueue getEventQueue() {
        return this.eventQueue;
    }

    @Override
    public IContentContext getContentContext() {
        return this.paintableCtx;
    }

    @Override
    public void setContentContext(IContentContext ctx) {
        this.paintableCtx = ctx;
    }

    @Override
    public void setLocked(boolean locked) {
        boolean previous = this.locked.getAndSet(locked);
        if (!locked && previous != locked) {
            this.getContentContext().setDirty();
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked.get();
    }

    public void assertParticipantDependencies() {
        ICanvasParticipant[] iCanvasParticipantArray = (ICanvasParticipant[])this.toArray();
        int n = iCanvasParticipantArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICanvasParticipant ctx = iCanvasParticipantArray[n2];
            if (ctx instanceof AbstractCanvasParticipant) {
                AbstractCanvasParticipant acp = (AbstractCanvasParticipant)ctx;
                if (!acp.depsSatisfied) {
                    throw new AssertionError((Object)("Participant " + acp + " dependencies unsatisfied : " + acp.missingDependencies));
                }
            }
            ++n2;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.locked.get()) {
            sb.append("[CanvasContext@" + System.identityHashCode(this) + " is locked]");
        }
        sb.append("Participants:\n");
        sb.append(EString.addPrefix((String)super.toString(), (String)"\t"));
        sb.append("\n\nEvent handler stack:\n");
        sb.append(EString.addPrefix((String)this.getEventHandlerStack().toString(), (String)"\t"));
        return sb.toString();
    }
}

