/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;

import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode2;

/**
 * @author Tuukka Lehtonen
 */
public class ShapeImage extends AbstractImage implements Image {

    private static final EnumSet<Feature> defaultFeats = VECTOR;

    Shape shape;
    Paint fillPaint;
    Paint strokePaint;
    Stroke stroke;
    EnumSet<Feature> feats;
    boolean scaleStroke = false;

    public ShapeImage(Shape shape, Paint fill, Stroke stroke) {
        this(shape, fill, stroke, defaultFeats);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, boolean scaleStroke) {
        this(shape, fill, stroke, fill, scaleStroke, defaultFeats);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, EnumSet<Feature> features) {
        this(shape, fill, stroke, fill, false, features);
    }
    public ShapeImage(Shape shape, Paint fill, Stroke stroke, Paint strokeColor, boolean scaleStroke)  {
    	 this(shape, fill, stroke, strokeColor, scaleStroke, defaultFeats);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, Paint strokeColor, boolean scaleStroke, EnumSet<Feature> features) {
        this.shape = shape;
        this.fillPaint = fill;
        this.strokePaint = strokeColor;
        this.stroke = stroke;
        this.scaleStroke = scaleStroke;
        this.feats = features;
    }

    @Override
    public Rectangle2D getBounds() {
        return shape.getBounds2D();
    }

    @Override
    public EnumSet<Feature> getFeatures() {
        return feats;
    }

    @Override
    public Shape getOutline() {
        return shape;
    }

    @Override
    public Node init(G2DParentNode parent) {
        ShapeNode2 shapeNode = parent.getOrCreateNode("ShapeImage", ShapeNode2.class);
        shapeNode.setShape(shape);
        shapeNode.setStroke(stroke);
        shapeNode.setFillColor(fillPaint);
        shapeNode.setStrokeColor(strokePaint != null ? strokePaint : Color.BLACK);
        shapeNode.setScaleStroke(scaleStroke);
        return shapeNode;
    }

};
