/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.example.chassis;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;

import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.example.TestCanvas;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * Run this example with VM args: -Dsun.java2d.opengl=true
 * @author Toni Kalajainen
 */
public class ConnectExample {

    public static void main(String[] args) {
        System.out.println(DefaultImages.HAND);

        // JFrame has double buffering, enabled by default
        JFrame frame = new JFrame("Hello World");
        // Add a window listner for close button
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        // This is an empty content area in the frame
        AWTChassis chassis = new AWTChassis();

        chassis.setPreferredSize(new Dimension(480, 320));

        // There is a background painter in canvas context (==it is opaque)
        chassis.setOpaque(true);
        frame.getContentPane().add(chassis, BorderLayout.CENTER);
        frame.pack();

        frame.setVisible(true);
        chassis.requestFocus();

        IThreadWorkQueue    thread  = AWTThread.getThreadAccess();
        CanvasContext       ctx     = TestCanvas.createDefaultCanvas(thread);
//        ctx.remove( ctx.getAtMostOneItemOfClass(HandPainter.class) );
        IHintContext        hintCtx = ctx.getDefaultHintContext();
        IDiagram            diagram = TestCanvas.createConnectTestDiagram();

        hintCtx.setHint(DiagramHints.KEY_DIAGRAM, diagram);
        chassis.setCanvasContext(ctx);
    }

}
