/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalData;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * TerminalDataImpl that is used in ElementClass
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class UniqueTerminalDataImpl implements TerminalData {

    private static final long serialVersionUID = -2131030904280472077L;

    private final Map<Terminal,Map<Key,Object>> terminals = new HashMap<Terminal, Map<Key,Object>>();

    public UniqueTerminalDataImpl(Collection<? extends Terminal> terminals) {
        for (Terminal t : terminals) {
            this.terminals.put(t, new HashMap<Key, Object>(2));
        }
    }



    @Override
    public <T> T getHint(IElement e, Terminal t, Key key) {
        Map<Key,Object> data = terminals.get(t);
        if (data != null)
            return (T)data.get(key);
        return null;
    }

    @Override
    public void setHint(IElement e, Terminal t, Key key, Object value) {
        Map<Key,Object> data = terminals.get(t);
        data.put(key, value);
    }

}
