/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Text;

/**
 * @author Toni Kalajainen
 */
public class TextImpl implements Text {

    private static final long serialVersionUID = 2214032026682004123L;

    public static final TextImpl INSTANCE = new TextImpl();

    @Override
    public String getText(IElement e) {
        return e.getHint(ElementHints.KEY_TEXT);
    }

    @Override
    public void setText(IElement e, String text) {
        if (text != null)
            e.setHint(ElementHints.KEY_TEXT, text);
        else
            e.removeHint(ElementHints.KEY_TEXT);
    }

}
