/*******************************************************************************
 * Copyright (c) 2007, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - #7119 refactoring
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import gnu.trove.map.hash.THashMap;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.utils.geom.DirectionSet;

/**
 * @author Tuukka Lehtonen
 */
public class Terminals implements TerminalLayout, TerminalTopology {

    private static final long serialVersionUID = -6532093690907028016L;

    protected final Map<Terminal, ObjectTerminal> terminalMap = new THashMap<>();
    protected final ArrayList<Terminal>           terminals   = new ArrayList<>();

    public Terminals(Collection<ObjectTerminal> ts) {
        for (ObjectTerminal ti : ts) {
            terminals.add(ti);
            terminalMap.put(ti, ti);
        }
    }

    @Override
    public AffineTransform getTerminalPosition(IElement node, Terminal t) {
        ObjectTerminal ti = terminalMap.get(t);
        if (ti == null)
            return null;
        return ti.getTransform();
    }

    @Override
    public void getTerminals(IElement e, Collection<Terminal> result) {
        result.addAll(terminals);
    }

    @Override
    public boolean getTerminalDirection(IElement node, Terminal t, DirectionSet directions) {
        ObjectTerminal ti = terminalMap.get(t);
        if (ti == null)
            return false;
        directions.addAll(ti.getDirections());
        return true;
    }

    @Override
    public Shape getTerminalShape(IElement node, Terminal t) {
        ObjectTerminal ti = terminalMap.get(t);
        if (ti == null)
            return null;
        return ti.getShape();
    }

    @Override
    public int hashCode() {
        return terminalMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Terminals other = (Terminals) obj;
        return terminalMap.equals(other.terminalMap);
    }

}