/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.impl;

import java.util.HashMap;
import java.util.Map;

import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.ElementFactory;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.connection.ConnectionClass;
import org.simantics.utils.datastructures.cache.ProvisionException;

/**
 * Diagrams manipulation requires a DiagramMutator. This one works without any
 * backend system.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 * @author Tuukka Lehtonen
 */
public class DummyDiagramMutator implements DiagramMutator {

    public static final IElementClassProvider DEFAULT_PROVIDER = ElementClassProviders.mappedProvider(
            ElementClasses.CONNECTION, ConnectionClass.CLASS.newClassWith(new StaticObjectAdapter(new Object())),
            ElementClasses.FLAG, FlagClass.FLAGCLASS.newClassWith(new StaticObjectAdapter(new Object()))
    );

    IElementClassProvider classProvider;

    private final Map<IElement, Object> map = new HashMap<IElement, Object>();

    private final IDiagram diagram;

    public DummyDiagramMutator(IDiagram diagram) {
        this(diagram, DEFAULT_PROVIDER);
    }

    public DummyDiagramMutator(IDiagram diagram, IElementClassProvider classProvider) {
        this.diagram = diagram;
        this.classProvider = classProvider;

        ensureClassProvision(ElementClasses.CONNECTION);
        ensureClassProvision(ElementClasses.FLAG);
    }

    private void ensureClassProvision(Object key) {
        ElementClass ec = classProvider.get(key);
        if (ec == null)
            throw new ProvisionException();
    }

    @Override
    public void synchronizeHintsToBackend(IElement element) {
        // No backend, nothing to synchronize
    }

    @Override
    public void synchronizeElementOrder() {
        // No backend, nothing to synchronize
    }

    @Override
    public void register(IElement element, Object object) {
        // No point in registering anything.
        map.put(element, object);
    }

    private IElement spawn(ElementClass clazz) {
        ElementFactory ef = diagram.getDiagramClass().getAtMostOneItemOfClass(ElementFactory.class);
        if (ef != null)
            return ef.spawnNew(clazz);
        return Element.spawnNew(clazz);
    }

    @Override
    public IElement newElement(ElementClass clazz) {
        IElement element = spawn(clazz);
        element.setHint(ElementHints.KEY_OBJECT, new Object());
        return element;
    }

    @Override
    public void modifyTransform(IElement element) {
    }

    @Override
    public void commit() {
        map.clear();
    }

    @Override
    public void clear() {
        map.clear();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T backendObject(IElement element) {
        return (T) map.get(element);
    }

}
