/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;

/**
 * An interface that is used for writing diagram modifications into the
 * back-end. It is basically a queue of ordered modifications. Performing these
 * modifications will cause back-end data model listeners to fire, making it
 * possible for the back-end => diagram synchronizer to keep the visual
 * appearance up-to-date with the data model.
 * 
 * <p>
 * To guarantee proper synchronization between back-end data model tracking and
 * back-end mutation, methods of this class should only be invoked within
 * diagram write transactions. See
 * {@link DiagramUtils#inDiagramTransaction(IDiagram, org.simantics.g2d.diagram.handler.TransactionContext.TransactionType, Runnable)}
 * and
 * {@link DiagramUtils#mutateDiagram(IDiagram, org.simantics.utils.datastructures.Callback)}.
 * 
 * @author Antti Villberg
 * @author Tuukka Lehtonen
 * 
 * @deprecated will be completely removed asap, do not use this, just write the
 *             data directly into the database.
 */
@Deprecated
public interface DiagramMutator {

    /**
     * Creates a modification that forces the hints of the specified element to
     * be synchronized with the back-end.
     * 
     * @param element
     */
    void synchronizeHintsToBackend(IElement element);

    void modifyTransform(IElement element);

    IElement newElement(ElementClass clazz);

    /**
     * Set the Z-Order of the specified element.
     * 
     * @param element
     * @param position
     */
    void synchronizeElementOrder();

    /**
     * Retrieve objects bound using {@link #register(IElement, Object)}. These
     * bindings will only stay alive until either {@link #clear()} or
     * {@link #commit()} is invoked.
     * 
     * @param <T>
     * @param element
     * @return
     */
    <T> T backendObject(IElement element);

    /**
     * For registering an element <-> back-end object binding which will be kept
     * until either {@link #clear()} or {@link #commit()} is invoked.
     * {@link #backendObject(IElement)} can be to retrieve the objects based on
     * these bindings which is necessary in cases where the write-back process
     * produces new back-end resources that are needed by modifications that are
     * performed later.
     * 
     * @param element
     * @param object
     */
    void register(IElement element, Object object);

    /**
     * Commits all changes that have been queue into the mutator since the
     * previous {@link #commit()} or {@link #clear()} invocation. A successful
     * commit will empty the mutator into a state which is essentially the same
     * as after invoking {@link #clear()}.
     */
    void commit();

    /**
     * Discard any changes that have been queued in the mutator by invocations
     * to any modifying methods. After this the queue will be empty. Can be
     * invoked at any time.
     */
    void clear();

}
