/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.connection;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Tuukka Lehtonen
 */
public class TerminalReference {

    private final Pair<IElement, Terminal> data;

    public TerminalReference(IElement node, Terminal terminal) {
        data = Pair.make(node, terminal);
    }

    public Object getNode() {
        return data.first;
    }

    public Terminal getTerminal() {
        return data.second;
    }

    @Override
    public int hashCode() {
        return data.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof TerminalReference))
            return false;
        TerminalReference other = (TerminalReference) obj;
        return data.equals(other.data);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + data + "]";
    }

}
