package org.simantics.diagram.stubs;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class G2DResource {
    
    public final Resource Alignment;
    public final Resource Alignment_Baseline;
    public final Resource Alignment_Center;
    public final Resource Alignment_Leading;
    public final Resource Alignment_Trailing;
    public final Resource Color;
    public final Resource ColorGradient;
    public final Resource ColorPlacement;
    public final Resource ColorProfile;
    public final Resource Colors;
    public final Resource DefaultStroke;
    public final Resource Font;
    public final Resource FontStyle;
    public final Resource FontStyle_bold_font_style;
    public final Resource FontStyle_bold_italic_style;
    public final Resource FontStyle_italic_font_style;
    public final Resource FontStyle_normal_font_style;
    public final Resource HasBeginArrow;
    public final Resource HasBeginArrow_Inverse;
    public final Resource HasBorderColor;
    public final Resource HasBorderColor_Inverse;
    public final Resource HasBounds;
    public final Resource HasBounds_Inverse;
    public final Resource HasBranchPointRadius;
    public final Resource HasBranchPointRadius_Inverse;
    public final Resource HasColor;
    public final Resource HasColorGradient;
    public final Resource HasColorGradient_Inverse;
    public final Resource HasColorPlacement;
    public final Resource HasColorPlacement_Inverse;
    public final Resource HasColor_Inverse;
    public final Resource HasDashArray;
    public final Resource HasDashArray_Inverse;
    public final Resource HasDashOffset;
    public final Resource HasDashOffset_Inverse;
    public final Resource HasEndArrow;
    public final Resource HasEndArrow_Inverse;
    public final Resource HasFillColor;
    public final Resource HasFillColor_Inverse;
    public final Resource HasFont;
    public final Resource HasFontFamily;
    public final Resource HasFontFamily_Inverse;
    public final Resource HasFontSize;
    public final Resource HasFontSize_Inverse;
    public final Resource HasFontStyle;
    public final Resource HasFont_Inverse;
    public final Resource HasGradientPosition;
    public final Resource HasGradientPosition_Inverse;
    public final Resource HasHorizontalAlignment;
    public final Resource HasLineCap;
    public final Resource HasLineEndStyle;
    public final Resource HasLineJoin;
    public final Resource HasLineSegmentTypes;
    public final Resource HasLineSegmentTypes_Inverse;
    public final Resource HasLineSegments;
    public final Resource HasLineSegments_Inverse;
    public final Resource HasMidArrow;
    public final Resource HasMidArrow_Inverse;
    public final Resource HasMiterLimit;
    public final Resource HasMiterLimit_Inverse;
    public final Resource HasOffset;
    public final Resource HasOffset_Inverse;
    public final Resource HasOpacity;
    public final Resource HasOpacity_Inverse;
    public final Resource HasPaint;
    public final Resource HasPaint_Inverse;
    public final Resource HasPathData;
    public final Resource HasPathData_Inverse;
    public final Resource HasPoint2D;
    public final Resource HasPoint2DArray;
    public final Resource HasPoint2DArray_Inverse;
    public final Resource HasPoint2D_Inverse;
    public final Resource HasRadii;
    public final Resource HasRadii_Inverse;
    public final Resource HasRasterImage;
    public final Resource HasRasterImage_Inverse;
    public final Resource HasRounding;
    public final Resource HasRounding_Inverse;
    public final Resource HasSVGDocument;
    public final Resource HasSVGDocument_Inverse;
    public final Resource HasSVGScript;
    public final Resource HasSVGScript_Inverse;
    public final Resource HasSize;
    public final Resource HasSize_Inverse;
    public final Resource HasSpace;
    public final Resource HasSpace_Inverse;
    public final Resource HasStroke;
    public final Resource HasStrokeType;
    public final Resource HasStrokeWidth;
    public final Resource HasStrokeWidth_Inverse;
    public final Resource HasStroke_Inverse;
    public final Resource HasStyle;
    public final Resource HasStyle_Inverse;
    public final Resource HasText;
    public final Resource HasText_Inverse;
    public final Resource HasTransform;
    public final Resource HasVerticalAlignment;
    public final Resource HasWidthRatio;
    public final Resource HasWidthRatio_Inverse;
    public final Resource IsTransformOf;
    public final Resource IsVisible;
    public final Resource IsVisible_Inverse;
    public final Resource LineCap;
    public final Resource LineCap_ButtCap;
    public final Resource LineCap_RoundCap;
    public final Resource LineCap_SquareCap;
    public final Resource LineEnd;
    public final Resource LineEndStyle;
    public final Resource LineEndStyle_FilledLineEndStyle;
    public final Resource LineEndStyle_NormalLineEndStyle;
    public final Resource LineJoin;
    public final Resource LineJoin_BevelJoin;
    public final Resource LineJoin_MiterJoin;
    public final Resource LineJoin_RoundJoin;
    public final Resource Point2D;
    public final Resource Point2DArray;
    public final Resource Rectangle2D;
    public final Resource Shape;
    public final Resource Stroke;
    public final Resource StrokeType;
    public final Resource StrokeType_Nonscaling;
    public final Resource StrokeType_Scaling;
    public final Resource Style;
    public final Resource Transform;
    public final Resource Transform_i$0;
    public final Resource Transform_i$0_Inverse;
    public final Resource Transform_i$1;
    public final Resource Transform_i$1_Inverse;
    public final Resource Transform_i$2;
    public final Resource Transform_i$2_Inverse;
    public final Resource Transform_i$3;
    public final Resource Transform_i$3_Inverse;
    public final Resource Transform_i$4;
    public final Resource Transform_i$4_Inverse;
    public final Resource Transform_i$5;
    public final Resource Transform_i$5_Inverse;
    public final Resource font;
    public final Resource fontProperty;
        
    public static class URIs {
        public static final String Alignment = "http://www.simantics.org/G2D-1.1/Alignment";
        public static final String Alignment_Baseline = "http://www.simantics.org/G2D-1.1/Alignment/Baseline";
        public static final String Alignment_Center = "http://www.simantics.org/G2D-1.1/Alignment/Center";
        public static final String Alignment_Leading = "http://www.simantics.org/G2D-1.1/Alignment/Leading";
        public static final String Alignment_Trailing = "http://www.simantics.org/G2D-1.1/Alignment/Trailing";
        public static final String Color = "http://www.simantics.org/G2D-1.1/Color";
        public static final String ColorGradient = "http://www.simantics.org/G2D-1.1/ColorGradient";
        public static final String ColorPlacement = "http://www.simantics.org/G2D-1.1/ColorPlacement";
        public static final String ColorProfile = "http://www.simantics.org/G2D-1.1/ColorProfile";
        public static final String Colors = "http://www.simantics.org/G2D-1.1/Colors";
        public static final String DefaultStroke = "http://www.simantics.org/G2D-1.1/DefaultStroke";
        public static final String Font = "http://www.simantics.org/G2D-1.1/Font";
        public static final String FontStyle = "http://www.simantics.org/G2D-1.1/FontStyle";
        public static final String FontStyle_bold_font_style = "http://www.simantics.org/G2D-1.1/FontStyle/bold_font_style";
        public static final String FontStyle_bold_italic_style = "http://www.simantics.org/G2D-1.1/FontStyle/bold_italic_style";
        public static final String FontStyle_italic_font_style = "http://www.simantics.org/G2D-1.1/FontStyle/italic_font_style";
        public static final String FontStyle_normal_font_style = "http://www.simantics.org/G2D-1.1/FontStyle/normal_font_style";
        public static final String HasBeginArrow = "http://www.simantics.org/G2D-1.1/HasBeginArrow";
        public static final String HasBeginArrow_Inverse = "http://www.simantics.org/G2D-1.1/HasBeginArrow/Inverse";
        public static final String HasBorderColor = "http://www.simantics.org/G2D-1.1/HasBorderColor";
        public static final String HasBorderColor_Inverse = "http://www.simantics.org/G2D-1.1/HasBorderColor/Inverse";
        public static final String HasBounds = "http://www.simantics.org/G2D-1.1/HasBounds";
        public static final String HasBounds_Inverse = "http://www.simantics.org/G2D-1.1/HasBounds/Inverse";
        public static final String HasBranchPointRadius = "http://www.simantics.org/G2D-1.1/HasBranchPointRadius";
        public static final String HasBranchPointRadius_Inverse = "http://www.simantics.org/G2D-1.1/HasBranchPointRadius/Inverse";
        public static final String HasColor = "http://www.simantics.org/G2D-1.1/HasColor";
        public static final String HasColorGradient = "http://www.simantics.org/G2D-1.1/HasColorGradient";
        public static final String HasColorGradient_Inverse = "http://www.simantics.org/G2D-1.1/HasColorGradient/Inverse";
        public static final String HasColorPlacement = "http://www.simantics.org/G2D-1.1/HasColorPlacement";
        public static final String HasColorPlacement_Inverse = "http://www.simantics.org/G2D-1.1/HasColorPlacement/Inverse";
        public static final String HasColor_Inverse = "http://www.simantics.org/G2D-1.1/HasColor/Inverse";
        public static final String HasDashArray = "http://www.simantics.org/G2D-1.1/HasDashArray";
        public static final String HasDashArray_Inverse = "http://www.simantics.org/G2D-1.1/HasDashArray/Inverse";
        public static final String HasDashOffset = "http://www.simantics.org/G2D-1.1/HasDashOffset";
        public static final String HasDashOffset_Inverse = "http://www.simantics.org/G2D-1.1/HasDashOffset/Inverse";
        public static final String HasEndArrow = "http://www.simantics.org/G2D-1.1/HasEndArrow";
        public static final String HasEndArrow_Inverse = "http://www.simantics.org/G2D-1.1/HasEndArrow/Inverse";
        public static final String HasFillColor = "http://www.simantics.org/G2D-1.1/HasFillColor";
        public static final String HasFillColor_Inverse = "http://www.simantics.org/G2D-1.1/HasFillColor/Inverse";
        public static final String HasFont = "http://www.simantics.org/G2D-1.1/HasFont";
        public static final String HasFontFamily = "http://www.simantics.org/G2D-1.1/HasFontFamily";
        public static final String HasFontFamily_Inverse = "http://www.simantics.org/G2D-1.1/HasFontFamily/Inverse";
        public static final String HasFontSize = "http://www.simantics.org/G2D-1.1/HasFontSize";
        public static final String HasFontSize_Inverse = "http://www.simantics.org/G2D-1.1/HasFontSize/Inverse";
        public static final String HasFontStyle = "http://www.simantics.org/G2D-1.1/HasFontStyle";
        public static final String HasFont_Inverse = "http://www.simantics.org/G2D-1.1/HasFont/Inverse";
        public static final String HasGradientPosition = "http://www.simantics.org/G2D-1.1/HasGradientPosition";
        public static final String HasGradientPosition_Inverse = "http://www.simantics.org/G2D-1.1/HasGradientPosition/Inverse";
        public static final String HasHorizontalAlignment = "http://www.simantics.org/G2D-1.1/HasHorizontalAlignment";
        public static final String HasLineCap = "http://www.simantics.org/G2D-1.1/HasLineCap";
        public static final String HasLineEndStyle = "http://www.simantics.org/G2D-1.1/HasLineEndStyle";
        public static final String HasLineJoin = "http://www.simantics.org/G2D-1.1/HasLineJoin";
        public static final String HasLineSegmentTypes = "http://www.simantics.org/G2D-1.1/HasLineSegmentTypes";
        public static final String HasLineSegmentTypes_Inverse = "http://www.simantics.org/G2D-1.1/HasLineSegmentTypes/Inverse";
        public static final String HasLineSegments = "http://www.simantics.org/G2D-1.1/HasLineSegments";
        public static final String HasLineSegments_Inverse = "http://www.simantics.org/G2D-1.1/HasLineSegments/Inverse";
        public static final String HasMidArrow = "http://www.simantics.org/G2D-1.1/HasMidArrow";
        public static final String HasMidArrow_Inverse = "http://www.simantics.org/G2D-1.1/HasMidArrow/Inverse";
        public static final String HasMiterLimit = "http://www.simantics.org/G2D-1.1/HasMiterLimit";
        public static final String HasMiterLimit_Inverse = "http://www.simantics.org/G2D-1.1/HasMiterLimit/Inverse";
        public static final String HasOffset = "http://www.simantics.org/G2D-1.1/HasOffset";
        public static final String HasOffset_Inverse = "http://www.simantics.org/G2D-1.1/HasOffset/Inverse";
        public static final String HasOpacity = "http://www.simantics.org/G2D-1.1/HasOpacity";
        public static final String HasOpacity_Inverse = "http://www.simantics.org/G2D-1.1/HasOpacity/Inverse";
        public static final String HasPaint = "http://www.simantics.org/G2D-1.1/HasPaint";
        public static final String HasPaint_Inverse = "http://www.simantics.org/G2D-1.1/HasPaint/Inverse";
        public static final String HasPathData = "http://www.simantics.org/G2D-1.1/HasPathData";
        public static final String HasPathData_Inverse = "http://www.simantics.org/G2D-1.1/HasPathData/Inverse";
        public static final String HasPoint2D = "http://www.simantics.org/G2D-1.1/HasPoint2D";
        public static final String HasPoint2DArray = "http://www.simantics.org/G2D-1.1/HasPoint2DArray";
        public static final String HasPoint2DArray_Inverse = "http://www.simantics.org/G2D-1.1/HasPoint2DArray/Inverse";
        public static final String HasPoint2D_Inverse = "http://www.simantics.org/G2D-1.1/HasPoint2D/Inverse";
        public static final String HasRadii = "http://www.simantics.org/G2D-1.1/HasRadii";
        public static final String HasRadii_Inverse = "http://www.simantics.org/G2D-1.1/HasRadii/Inverse";
        public static final String HasRasterImage = "http://www.simantics.org/G2D-1.1/HasRasterImage";
        public static final String HasRasterImage_Inverse = "http://www.simantics.org/G2D-1.1/HasRasterImage/Inverse";
        public static final String HasRounding = "http://www.simantics.org/G2D-1.1/HasRounding";
        public static final String HasRounding_Inverse = "http://www.simantics.org/G2D-1.1/HasRounding/Inverse";
        public static final String HasSVGDocument = "http://www.simantics.org/G2D-1.1/HasSVGDocument";
        public static final String HasSVGDocument_Inverse = "http://www.simantics.org/G2D-1.1/HasSVGDocument/Inverse";
        public static final String HasSVGScript = "http://www.simantics.org/G2D-1.1/HasSVGScript";
        public static final String HasSVGScript_Inverse = "http://www.simantics.org/G2D-1.1/HasSVGScript/Inverse";
        public static final String HasSize = "http://www.simantics.org/G2D-1.1/HasSize";
        public static final String HasSize_Inverse = "http://www.simantics.org/G2D-1.1/HasSize/Inverse";
        public static final String HasSpace = "http://www.simantics.org/G2D-1.1/HasSpace";
        public static final String HasSpace_Inverse = "http://www.simantics.org/G2D-1.1/HasSpace/Inverse";
        public static final String HasStroke = "http://www.simantics.org/G2D-1.1/HasStroke";
        public static final String HasStrokeType = "http://www.simantics.org/G2D-1.1/HasStrokeType";
        public static final String HasStrokeWidth = "http://www.simantics.org/G2D-1.1/HasStrokeWidth";
        public static final String HasStrokeWidth_Inverse = "http://www.simantics.org/G2D-1.1/HasStrokeWidth/Inverse";
        public static final String HasStroke_Inverse = "http://www.simantics.org/G2D-1.1/HasStroke/Inverse";
        public static final String HasStyle = "http://www.simantics.org/G2D-1.1/HasStyle";
        public static final String HasStyle_Inverse = "http://www.simantics.org/G2D-1.1/HasStyle/Inverse";
        public static final String HasText = "http://www.simantics.org/G2D-1.1/HasText";
        public static final String HasText_Inverse = "http://www.simantics.org/G2D-1.1/HasText/Inverse";
        public static final String HasTransform = "http://www.simantics.org/G2D-1.1/HasTransform";
        public static final String HasVerticalAlignment = "http://www.simantics.org/G2D-1.1/HasVerticalAlignment";
        public static final String HasWidthRatio = "http://www.simantics.org/G2D-1.1/HasWidthRatio";
        public static final String HasWidthRatio_Inverse = "http://www.simantics.org/G2D-1.1/HasWidthRatio/Inverse";
        public static final String IsTransformOf = "http://www.simantics.org/G2D-1.1/IsTransformOf";
        public static final String IsVisible = "http://www.simantics.org/G2D-1.1/IsVisible";
        public static final String IsVisible_Inverse = "http://www.simantics.org/G2D-1.1/IsVisible/Inverse";
        public static final String LineCap = "http://www.simantics.org/G2D-1.1/LineCap";
        public static final String LineCap_ButtCap = "http://www.simantics.org/G2D-1.1/LineCap/ButtCap";
        public static final String LineCap_RoundCap = "http://www.simantics.org/G2D-1.1/LineCap/RoundCap";
        public static final String LineCap_SquareCap = "http://www.simantics.org/G2D-1.1/LineCap/SquareCap";
        public static final String LineEnd = "http://www.simantics.org/G2D-1.1/LineEnd";
        public static final String LineEndStyle = "http://www.simantics.org/G2D-1.1/LineEndStyle";
        public static final String LineEndStyle_FilledLineEndStyle = "http://www.simantics.org/G2D-1.1/LineEndStyle/FilledLineEndStyle";
        public static final String LineEndStyle_NormalLineEndStyle = "http://www.simantics.org/G2D-1.1/LineEndStyle/NormalLineEndStyle";
        public static final String LineJoin = "http://www.simantics.org/G2D-1.1/LineJoin";
        public static final String LineJoin_BevelJoin = "http://www.simantics.org/G2D-1.1/LineJoin/BevelJoin";
        public static final String LineJoin_MiterJoin = "http://www.simantics.org/G2D-1.1/LineJoin/MiterJoin";
        public static final String LineJoin_RoundJoin = "http://www.simantics.org/G2D-1.1/LineJoin/RoundJoin";
        public static final String Point2D = "http://www.simantics.org/G2D-1.1/Point2D";
        public static final String Point2DArray = "http://www.simantics.org/G2D-1.1/Point2DArray";
        public static final String Rectangle2D = "http://www.simantics.org/G2D-1.1/Rectangle2D";
        public static final String Shape = "http://www.simantics.org/G2D-1.1/Shape";
        public static final String Stroke = "http://www.simantics.org/G2D-1.1/Stroke";
        public static final String StrokeType = "http://www.simantics.org/G2D-1.1/StrokeType";
        public static final String StrokeType_Nonscaling = "http://www.simantics.org/G2D-1.1/StrokeType/Nonscaling";
        public static final String StrokeType_Scaling = "http://www.simantics.org/G2D-1.1/StrokeType/Scaling";
        public static final String Style = "http://www.simantics.org/G2D-1.1/Style";
        public static final String Transform = "http://www.simantics.org/G2D-1.1/Transform";
        public static final String Transform_i$0 = "http://www.simantics.org/G2D-1.1/Transform/i-0";
        public static final String Transform_i$0_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-0/Inverse";
        public static final String Transform_i$1 = "http://www.simantics.org/G2D-1.1/Transform/i-1";
        public static final String Transform_i$1_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-1/Inverse";
        public static final String Transform_i$2 = "http://www.simantics.org/G2D-1.1/Transform/i-2";
        public static final String Transform_i$2_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-2/Inverse";
        public static final String Transform_i$3 = "http://www.simantics.org/G2D-1.1/Transform/i-3";
        public static final String Transform_i$3_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-3/Inverse";
        public static final String Transform_i$4 = "http://www.simantics.org/G2D-1.1/Transform/i-4";
        public static final String Transform_i$4_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-4/Inverse";
        public static final String Transform_i$5 = "http://www.simantics.org/G2D-1.1/Transform/i-5";
        public static final String Transform_i$5_Inverse = "http://www.simantics.org/G2D-1.1/Transform/i-5/Inverse";
        public static final String font = "http://www.simantics.org/G2D-1.1/font";
        public static final String fontProperty = "http://www.simantics.org/G2D-1.1/fontProperty";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public G2DResource(ReadGraph graph) {
        Alignment = getResourceOrNull(graph, URIs.Alignment);
        Alignment_Baseline = getResourceOrNull(graph, URIs.Alignment_Baseline);
        Alignment_Center = getResourceOrNull(graph, URIs.Alignment_Center);
        Alignment_Leading = getResourceOrNull(graph, URIs.Alignment_Leading);
        Alignment_Trailing = getResourceOrNull(graph, URIs.Alignment_Trailing);
        Color = getResourceOrNull(graph, URIs.Color);
        ColorGradient = getResourceOrNull(graph, URIs.ColorGradient);
        ColorPlacement = getResourceOrNull(graph, URIs.ColorPlacement);
        ColorProfile = getResourceOrNull(graph, URIs.ColorProfile);
        Colors = getResourceOrNull(graph, URIs.Colors);
        DefaultStroke = getResourceOrNull(graph, URIs.DefaultStroke);
        Font = getResourceOrNull(graph, URIs.Font);
        FontStyle = getResourceOrNull(graph, URIs.FontStyle);
        FontStyle_bold_font_style = getResourceOrNull(graph, URIs.FontStyle_bold_font_style);
        FontStyle_bold_italic_style = getResourceOrNull(graph, URIs.FontStyle_bold_italic_style);
        FontStyle_italic_font_style = getResourceOrNull(graph, URIs.FontStyle_italic_font_style);
        FontStyle_normal_font_style = getResourceOrNull(graph, URIs.FontStyle_normal_font_style);
        HasBeginArrow = getResourceOrNull(graph, URIs.HasBeginArrow);
        HasBeginArrow_Inverse = getResourceOrNull(graph, URIs.HasBeginArrow_Inverse);
        HasBorderColor = getResourceOrNull(graph, URIs.HasBorderColor);
        HasBorderColor_Inverse = getResourceOrNull(graph, URIs.HasBorderColor_Inverse);
        HasBounds = getResourceOrNull(graph, URIs.HasBounds);
        HasBounds_Inverse = getResourceOrNull(graph, URIs.HasBounds_Inverse);
        HasBranchPointRadius = getResourceOrNull(graph, URIs.HasBranchPointRadius);
        HasBranchPointRadius_Inverse = getResourceOrNull(graph, URIs.HasBranchPointRadius_Inverse);
        HasColor = getResourceOrNull(graph, URIs.HasColor);
        HasColorGradient = getResourceOrNull(graph, URIs.HasColorGradient);
        HasColorGradient_Inverse = getResourceOrNull(graph, URIs.HasColorGradient_Inverse);
        HasColorPlacement = getResourceOrNull(graph, URIs.HasColorPlacement);
        HasColorPlacement_Inverse = getResourceOrNull(graph, URIs.HasColorPlacement_Inverse);
        HasColor_Inverse = getResourceOrNull(graph, URIs.HasColor_Inverse);
        HasDashArray = getResourceOrNull(graph, URIs.HasDashArray);
        HasDashArray_Inverse = getResourceOrNull(graph, URIs.HasDashArray_Inverse);
        HasDashOffset = getResourceOrNull(graph, URIs.HasDashOffset);
        HasDashOffset_Inverse = getResourceOrNull(graph, URIs.HasDashOffset_Inverse);
        HasEndArrow = getResourceOrNull(graph, URIs.HasEndArrow);
        HasEndArrow_Inverse = getResourceOrNull(graph, URIs.HasEndArrow_Inverse);
        HasFillColor = getResourceOrNull(graph, URIs.HasFillColor);
        HasFillColor_Inverse = getResourceOrNull(graph, URIs.HasFillColor_Inverse);
        HasFont = getResourceOrNull(graph, URIs.HasFont);
        HasFontFamily = getResourceOrNull(graph, URIs.HasFontFamily);
        HasFontFamily_Inverse = getResourceOrNull(graph, URIs.HasFontFamily_Inverse);
        HasFontSize = getResourceOrNull(graph, URIs.HasFontSize);
        HasFontSize_Inverse = getResourceOrNull(graph, URIs.HasFontSize_Inverse);
        HasFontStyle = getResourceOrNull(graph, URIs.HasFontStyle);
        HasFont_Inverse = getResourceOrNull(graph, URIs.HasFont_Inverse);
        HasGradientPosition = getResourceOrNull(graph, URIs.HasGradientPosition);
        HasGradientPosition_Inverse = getResourceOrNull(graph, URIs.HasGradientPosition_Inverse);
        HasHorizontalAlignment = getResourceOrNull(graph, URIs.HasHorizontalAlignment);
        HasLineCap = getResourceOrNull(graph, URIs.HasLineCap);
        HasLineEndStyle = getResourceOrNull(graph, URIs.HasLineEndStyle);
        HasLineJoin = getResourceOrNull(graph, URIs.HasLineJoin);
        HasLineSegmentTypes = getResourceOrNull(graph, URIs.HasLineSegmentTypes);
        HasLineSegmentTypes_Inverse = getResourceOrNull(graph, URIs.HasLineSegmentTypes_Inverse);
        HasLineSegments = getResourceOrNull(graph, URIs.HasLineSegments);
        HasLineSegments_Inverse = getResourceOrNull(graph, URIs.HasLineSegments_Inverse);
        HasMidArrow = getResourceOrNull(graph, URIs.HasMidArrow);
        HasMidArrow_Inverse = getResourceOrNull(graph, URIs.HasMidArrow_Inverse);
        HasMiterLimit = getResourceOrNull(graph, URIs.HasMiterLimit);
        HasMiterLimit_Inverse = getResourceOrNull(graph, URIs.HasMiterLimit_Inverse);
        HasOffset = getResourceOrNull(graph, URIs.HasOffset);
        HasOffset_Inverse = getResourceOrNull(graph, URIs.HasOffset_Inverse);
        HasOpacity = getResourceOrNull(graph, URIs.HasOpacity);
        HasOpacity_Inverse = getResourceOrNull(graph, URIs.HasOpacity_Inverse);
        HasPaint = getResourceOrNull(graph, URIs.HasPaint);
        HasPaint_Inverse = getResourceOrNull(graph, URIs.HasPaint_Inverse);
        HasPathData = getResourceOrNull(graph, URIs.HasPathData);
        HasPathData_Inverse = getResourceOrNull(graph, URIs.HasPathData_Inverse);
        HasPoint2D = getResourceOrNull(graph, URIs.HasPoint2D);
        HasPoint2DArray = getResourceOrNull(graph, URIs.HasPoint2DArray);
        HasPoint2DArray_Inverse = getResourceOrNull(graph, URIs.HasPoint2DArray_Inverse);
        HasPoint2D_Inverse = getResourceOrNull(graph, URIs.HasPoint2D_Inverse);
        HasRadii = getResourceOrNull(graph, URIs.HasRadii);
        HasRadii_Inverse = getResourceOrNull(graph, URIs.HasRadii_Inverse);
        HasRasterImage = getResourceOrNull(graph, URIs.HasRasterImage);
        HasRasterImage_Inverse = getResourceOrNull(graph, URIs.HasRasterImage_Inverse);
        HasRounding = getResourceOrNull(graph, URIs.HasRounding);
        HasRounding_Inverse = getResourceOrNull(graph, URIs.HasRounding_Inverse);
        HasSVGDocument = getResourceOrNull(graph, URIs.HasSVGDocument);
        HasSVGDocument_Inverse = getResourceOrNull(graph, URIs.HasSVGDocument_Inverse);
        HasSVGScript = getResourceOrNull(graph, URIs.HasSVGScript);
        HasSVGScript_Inverse = getResourceOrNull(graph, URIs.HasSVGScript_Inverse);
        HasSize = getResourceOrNull(graph, URIs.HasSize);
        HasSize_Inverse = getResourceOrNull(graph, URIs.HasSize_Inverse);
        HasSpace = getResourceOrNull(graph, URIs.HasSpace);
        HasSpace_Inverse = getResourceOrNull(graph, URIs.HasSpace_Inverse);
        HasStroke = getResourceOrNull(graph, URIs.HasStroke);
        HasStrokeType = getResourceOrNull(graph, URIs.HasStrokeType);
        HasStrokeWidth = getResourceOrNull(graph, URIs.HasStrokeWidth);
        HasStrokeWidth_Inverse = getResourceOrNull(graph, URIs.HasStrokeWidth_Inverse);
        HasStroke_Inverse = getResourceOrNull(graph, URIs.HasStroke_Inverse);
        HasStyle = getResourceOrNull(graph, URIs.HasStyle);
        HasStyle_Inverse = getResourceOrNull(graph, URIs.HasStyle_Inverse);
        HasText = getResourceOrNull(graph, URIs.HasText);
        HasText_Inverse = getResourceOrNull(graph, URIs.HasText_Inverse);
        HasTransform = getResourceOrNull(graph, URIs.HasTransform);
        HasVerticalAlignment = getResourceOrNull(graph, URIs.HasVerticalAlignment);
        HasWidthRatio = getResourceOrNull(graph, URIs.HasWidthRatio);
        HasWidthRatio_Inverse = getResourceOrNull(graph, URIs.HasWidthRatio_Inverse);
        IsTransformOf = getResourceOrNull(graph, URIs.IsTransformOf);
        IsVisible = getResourceOrNull(graph, URIs.IsVisible);
        IsVisible_Inverse = getResourceOrNull(graph, URIs.IsVisible_Inverse);
        LineCap = getResourceOrNull(graph, URIs.LineCap);
        LineCap_ButtCap = getResourceOrNull(graph, URIs.LineCap_ButtCap);
        LineCap_RoundCap = getResourceOrNull(graph, URIs.LineCap_RoundCap);
        LineCap_SquareCap = getResourceOrNull(graph, URIs.LineCap_SquareCap);
        LineEnd = getResourceOrNull(graph, URIs.LineEnd);
        LineEndStyle = getResourceOrNull(graph, URIs.LineEndStyle);
        LineEndStyle_FilledLineEndStyle = getResourceOrNull(graph, URIs.LineEndStyle_FilledLineEndStyle);
        LineEndStyle_NormalLineEndStyle = getResourceOrNull(graph, URIs.LineEndStyle_NormalLineEndStyle);
        LineJoin = getResourceOrNull(graph, URIs.LineJoin);
        LineJoin_BevelJoin = getResourceOrNull(graph, URIs.LineJoin_BevelJoin);
        LineJoin_MiterJoin = getResourceOrNull(graph, URIs.LineJoin_MiterJoin);
        LineJoin_RoundJoin = getResourceOrNull(graph, URIs.LineJoin_RoundJoin);
        Point2D = getResourceOrNull(graph, URIs.Point2D);
        Point2DArray = getResourceOrNull(graph, URIs.Point2DArray);
        Rectangle2D = getResourceOrNull(graph, URIs.Rectangle2D);
        Shape = getResourceOrNull(graph, URIs.Shape);
        Stroke = getResourceOrNull(graph, URIs.Stroke);
        StrokeType = getResourceOrNull(graph, URIs.StrokeType);
        StrokeType_Nonscaling = getResourceOrNull(graph, URIs.StrokeType_Nonscaling);
        StrokeType_Scaling = getResourceOrNull(graph, URIs.StrokeType_Scaling);
        Style = getResourceOrNull(graph, URIs.Style);
        Transform = getResourceOrNull(graph, URIs.Transform);
        Transform_i$0 = getResourceOrNull(graph, URIs.Transform_i$0);
        Transform_i$0_Inverse = getResourceOrNull(graph, URIs.Transform_i$0_Inverse);
        Transform_i$1 = getResourceOrNull(graph, URIs.Transform_i$1);
        Transform_i$1_Inverse = getResourceOrNull(graph, URIs.Transform_i$1_Inverse);
        Transform_i$2 = getResourceOrNull(graph, URIs.Transform_i$2);
        Transform_i$2_Inverse = getResourceOrNull(graph, URIs.Transform_i$2_Inverse);
        Transform_i$3 = getResourceOrNull(graph, URIs.Transform_i$3);
        Transform_i$3_Inverse = getResourceOrNull(graph, URIs.Transform_i$3_Inverse);
        Transform_i$4 = getResourceOrNull(graph, URIs.Transform_i$4);
        Transform_i$4_Inverse = getResourceOrNull(graph, URIs.Transform_i$4_Inverse);
        Transform_i$5 = getResourceOrNull(graph, URIs.Transform_i$5);
        Transform_i$5_Inverse = getResourceOrNull(graph, URIs.Transform_i$5_Inverse);
        font = getResourceOrNull(graph, URIs.font);
        fontProperty = getResourceOrNull(graph, URIs.fontProperty);
    }
    
    public static G2DResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        G2DResource ret = session.peekService(G2DResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new G2DResource(qc.getIndependentGraph(graph));
            session.registerService(G2DResource.class, ret);
        }
        return ret;
    }
    
    public static G2DResource getInstance(RequestProcessor session) throws DatabaseException {
        G2DResource ret = session.peekService(G2DResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<G2DResource>() {
                public G2DResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new G2DResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(G2DResource.class, ret);
        }
        return ret;
    }
    
}

