#!/bin/bash
#*******************************************************************************
# Copyright (c) 2007, 2010 Association for Decentralized Information Management
# in Industry THTH ry.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
#     VTT Technical Research Centre of Finland - initial API and implementation
#*******************************************************************************

if [ -z $JAVA_HOME ]; then
    echo "JAVA_HOME is not defined, it is needed to find JNI headers (jni.h + jni_md.h)"
    exit -1
fi

kernel=`uname -s | tr "[:upper:]" "[:lower:]"`
arch=`uname -m | tr "[:upper:]" "[:lower:]"`

#default empty
extraparams=""

if [ $# -gt 0 ]; then
    arch=$1
fi

case $arch in
    i386|i586|i686)
	arch="x86"
	;;
esac

case $arch in
    x86)
	extraparams="-m32 -Os"
	;;
    x86_64)
	extraparams="-O3"
	;;
esac

#on macs force 64
case $kernel in
    darwin)
	arch="x86_64"
	extraparams="-dynamiclib -arch x86_64"
	;;
esac

options="${extraparams} -Wall -I${JAVA_HOME}/include -I${JAVA_HOME}/include/linux -std=c99 -Wall -W -Wundef -Wno-implicit-function-declaration -fPIC -shared"
output="../src/libfastlz-${kernel}-${arch}"

case $kernel in
    darwin*)
	output="${output}.dylib"
	;;
    *)
	output="${output}.so"
esac

echo "Kernel: $kernel"
echo "Architecture: $arch"
echo "Output library: $output"
echo "Compiler options: $options"

gcc ${options} -o ${output} fastlz.c jniWrapper.c

size=`ls -l $output | cut -d " " -f 5`
echo "library size before stripping: $size"

strip $output

size=`ls -l $output | cut -d " " -f 5`
echo "library size after stripping:  $size"

gcc ${extraparams} -o fastlz_test fastlz.c fastlz_read.c fastlz_write.c fastlz_test.c
