/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.export.core.internal.Activator;
import org.simantics.export.core.pdf.PdfExportPageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBasedPdfExportPageEvent
extends PdfPageEventHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBasedPdfExportPageEvent.class);
    Map<String, PdfExportPageEvent> events = ServiceBasedPdfExportPageEvent.collectEvents();

    private static Map<String, PdfExportPageEvent> collectEvents() {
        List<ServiceReference> serviceReferences;
        BundleContext context = Activator.getContext();
        try {
            serviceReferences = context.getServiceReferences(PdfExportPageEvent.class, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            serviceReferences = Collections.emptyList();
        }
        HashMap<String, PdfExportPageEvent> events = new HashMap<String, PdfExportPageEvent>(serviceReferences.size());
        for (ServiceReference reference : serviceReferences) {
            PdfExportPageEvent event = (PdfExportPageEvent)context.getService(reference);
            String eventName = event.toString();
            events.put(eventName, event);
        }
        return events;
    }

    private void safeInvoke(String eventName, PdfExportPageEvent event, Consumer<PdfExportPageEvent> r) {
        try {
            r.accept(event);
        }
        catch (Exception e) {
            LOGGER.error("Failed to invoke PdfExportPageEvent::" + eventName + " for " + event.toString(), (Throwable)e);
        }
    }

    public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
        this.events.values().forEach(e -> this.safeInvoke("onChapter", (PdfExportPageEvent)e, ee -> ee.onChapter(writer, document, paragraphPosition, title)));
    }

    public void onChapterEnd(PdfWriter writer, Document document, float position) {
        this.events.values().forEach(e -> this.safeInvoke("onChapterEnd", (PdfExportPageEvent)e, ee -> ee.onChapterEnd(writer, document, position)));
    }

    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        this.events.values().forEach(e -> this.safeInvoke("onGenericTag", (PdfExportPageEvent)e, ee -> ee.onGenericTag(writer, document, rect, text)));
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.events.values().forEach(e -> this.safeInvoke("onOpenDocument", (PdfExportPageEvent)e, ee -> ee.onOpenDocument(writer, document)));
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.events.values().forEach(e -> this.safeInvoke("onCloseDocument", (PdfExportPageEvent)e, ee -> ee.onCloseDocument(writer, document)));
    }

    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {
        this.events.values().forEach(e -> this.safeInvoke("onParagraph", (PdfExportPageEvent)e, ee -> ee.onParagraph(writer, document, paragraphPosition)));
    }

    public void onParagraphEnd(PdfWriter writer, Document document, float paragraphPosition) {
        this.events.values().forEach(e -> this.safeInvoke("onParagraphEnd", (PdfExportPageEvent)e, ee -> ee.onParagraphEnd(writer, document, paragraphPosition)));
    }

    public void onSection(PdfWriter writer, Document document, float paragraphPosition, int depth, Paragraph title) {
        this.events.values().forEach(e -> this.safeInvoke("onSection", (PdfExportPageEvent)e, ee -> ee.onSection(writer, document, paragraphPosition, depth, title)));
    }

    public void onSectionEnd(PdfWriter writer, Document document, float position) {
        this.events.values().forEach(e -> this.safeInvoke("onSectionEnd", (PdfExportPageEvent)e, ee -> ee.onSectionEnd(writer, document, position)));
    }

    public void onStartPage(PdfWriter writer, Document document) {
        this.events.values().forEach(e -> this.safeInvoke("onStartPage", (PdfExportPageEvent)e, ee -> ee.onStartPage(writer, document)));
    }

    public void onEndPage(PdfWriter writer, Document document) {
        this.events.values().forEach(e -> this.safeInvoke("onEndPage", (PdfExportPageEvent)e, ee -> ee.onEndPage(writer, document)));
    }
}

