/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import java.util.concurrent.atomic.AtomicBoolean;

public class FontMapping {
    private static final AtomicBoolean fontFactoryInitialized = new AtomicBoolean();

    public static FontMapper defaultFontMapper() {
        return FontMapping.createDefaultFontMapper();
    }

    public static FontMapper createDefaultFontMapper() {
        FontMapping.initializeFontFactory();
        DefaultFontMapper mapper = new DefaultFontMapper();
        FontMapping.insertDirectories(mapper);
        return mapper;
    }

    private static void insertDirectories(DefaultFontMapper mapper) {
        switch (OSType.calculate()) {
            case APPLE: {
                mapper.insertDirectory("/Library/Fonts");
                mapper.insertDirectory("/System/Library/Fonts");
            }
            case LINUX: 
            case SUN: {
                mapper.insertDirectory("/usr/share/X11/fonts");
                mapper.insertDirectory("/usr/X/lib/X11/fonts");
                mapper.insertDirectory("/usr/openwin/lib/X11/fonts");
                mapper.insertDirectory("/usr/share/fonts");
                mapper.insertDirectory("/usr/X11R6/lib/X11/fonts");
                break;
            }
            case WINDOWS: {
                String windir = System.getenv("WINDIR");
                if (windir == null || windir.isEmpty()) break;
                mapper.insertDirectory(String.valueOf(windir) + "\\Fonts");
                break;
            }
        }
    }

    private static void initializeFontFactory() {
        if (!fontFactoryInitialized.compareAndSet(false, true)) {
            return;
        }
        switch (OSType.calculate()) {
            case APPLE: {
                FontFactory.registerDirectory((String)"/Library/Fonts");
                FontFactory.registerDirectory((String)"/System/Library/Fonts");
            }
            case LINUX: 
            case SUN: {
                FontFactory.registerDirectory((String)"/usr/share/X11/fonts", (boolean)true);
                FontFactory.registerDirectory((String)"/usr/X/lib/X11/fonts", (boolean)true);
                FontFactory.registerDirectory((String)"/usr/openwin/lib/X11/fonts", (boolean)true);
                FontFactory.registerDirectory((String)"/usr/share/fonts", (boolean)true);
                FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts", (boolean)true);
                break;
            }
            case WINDOWS: {
                String windir = System.getenv("WINDIR");
                if (windir == null || windir.isEmpty()) break;
                FontFactory.registerDirectory((String)(String.valueOf(windir) + "\\Fonts"));
                break;
            }
        }
    }

    static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType APPLE = new OSType();
        public static final /* enum */ OSType LINUX = new OSType();
        public static final /* enum */ OSType SUN = new OSType();
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OSType[]{APPLE, LINUX, SUN, WINDOWS, UNKNOWN};
        }

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert (osName != null);
            if ((osName = osName.toLowerCase()).startsWith("mac os x")) {
                return APPLE;
            }
            if (osName.startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.startsWith("linux")) {
                return LINUX;
            }
            if (osName.startsWith("sun")) {
                return SUN;
            }
            return UNKNOWN;
        }

        public static OSType[] values() {
            OSType[] oSTypeArray = ENUM$VALUES;
            int n = oSTypeArray.length;
            OSType[] oSTypeArray2 = new OSType[n];
            System.arraycopy(ENUM$VALUES, 0, oSTypeArray2, 0, n);
            return oSTypeArray2;
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }
}

