package org.simantics.export.core.manager;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.RequestProcessor;
import org.simantics.export.core.error.ExportException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;

public class TransferableGraphWriter {

	public final File file;		
	public final String format;
	public final int version;
	
	public TransferableGraphWriter(File file, String format, int version) {
		this.file = file;
		this.format = format;
		this.version = version;
	}
	
	/**
	 * Write TG to the file that is associated with this writer.
	 * 
	 * @param tgBinding
	 * @param tg
	 * @throws ExportException
	 */
	public void writeFile(Binding tgBinding, Object tg) throws ExportException {
        try {
    		Variant variant = new Variant(tgBinding, tg);
    		DataContainer dataContainer = new DataContainer(format, version, variant);
			DataContainers.writeFile(file, dataContainer);
		} catch (IOException e) {
			throw new ExportException( "I/O Error occured: "+e.getMessage() );
		}				
	}
	
	/**
	 * Write from TG Source to the file that is associated with this writer.
	 *  
	 * @param session request processor to be used for reading the source
	 * @param source TG source
	 * @throws ExportException
	 */
	public void writeFile(RequestProcessor session, TransferableGraphSource source) throws ExportException
	{
		writeFile(session, source, new TreeMap<String, Variant>());
	}

	/**
	 * Write from TG Source to the file that is associated with this writer.
	 *  
	 * @param session request processor to be used for reading the source
	 * @param source TG source
	 * @throws ExportException
	 */
	public void writeFile(RequestProcessor session, TransferableGraphSource source, TreeMap<String,Variant> metadata) throws ExportException
	{
		try {
			TransferableGraphs.writeTransferableGraph(
					session, 
					format, 
					version, 
					metadata, 
					source, 
					file);
		} catch (Exception e) {
			throw new ExportException(e);
		}
	}

}
