package org.simantics.export.core.intf;

import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.manager.Content;
import org.simantics.utils.datastructures.MapList;

public interface ExportClass {
	
	/**
	 * Get extension specific options.
	 * 
	 * @param ctx
	 * @param contentUris
	 * @return a record type describing options 
	 */
	RecordType options( ExportContext ctx, Collection<String> contentUris ) throws ExportException;
	
	/**
	 * Validate that the content can be exported. If not, an exception is thrown. 
	 * 
	 * @param contentUri
	 * @param writer
	 * @param context
	 * @param monitor
	 * @param options
	 * @return list of errors  
	 */
	List<String> validate(
			String contentUri, 
			ExportContext context,
			Variant options);
	
	/**
	 * Write format specific content to a content writer. 
	 * 
	 * @param contentUris a list of uris
	 * @param writer a writer object that is created with format extension
	 * @param ctx export context
	 * @param options all export options in a variant
	 * @param monitor
	 * @param attachmentMap (optional) attachments 
	 * @throws ExportException
	 */
	void export(
			List<Content> contents, 
			Object writer, 
			ExportContext ctx,
			Variant options,
			IProgressMonitor monitor, 
			MapList<Content, Content> attachmentMap
			) throws ExportException;

	/**
	 * Fill the options object with default values.
	 * 
	 * @param ctx 
	 * @param options
	 */
	void fillDefaultPrefs( ExportContext ctx, Variant options ) throws ExportException;

	/**
	 * Save export options to preferences node(s).
	 * 
	 * @param options
	 * @param contentScopePrefs
	 * @param workspaceScopePrefs
	 * @throws ExportException
	 */
	void savePref( Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs ) throws ExportException;
	
	/**
	 * Load export options from preferences node(s).
	 * 
	 * @param options
	 * @param contentScopeNode
	 * @param workspaceScopePrefs
	 * @throws ExportException
	 */
	void loadPref( Variant options, Preferences contentScopeNode, Preferences workspaceScopePrefs ) throws ExportException;
	
}
