/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.event.util.EventExporter;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class ExportEventsAsCsv
extends AbstractHandler {
    private static final String PROP_LAST_PATH = "event.csv.export.path";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        try {
            String fileName = this.generateFileName();
            this.validate(window, fileName);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private String generateFileName() throws DatabaseException {
        String generatedName = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Iterator iterator = ((Collection)graph.syncRequest((Read)new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model))).iterator();
                if (iterator.hasNext()) {
                    Resource model = (Resource)iterator.next();
                    return String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)model)) + "-events-" + this.getTimestamp() + ".txt";
                }
                return "events-" + this.getTimestamp() + ".txt";
            }

            private String getTimestamp() {
                Calendar c = Calendar.getInstance();
                return String.valueOf(c.get(1)) + "-" + (1 + c.get(2)) + "-" + c.get(5) + "_" + c.get(11) + "-" + c.get(12) + "-" + c.get(13);
            }
        });
        if (!FileUtils.isValidFileName((String)generatedName)) {
            generatedName = (String)Bindings.STR_VARIANT.createUnchecked((Binding)Bindings.STRING, (Object)generatedName);
        }
        return generatedName;
    }

    public void validate(IWorkbenchWindow window, String fileName) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.event");
        String lastReportPath = prefs.get(PROP_LAST_PATH, null);
        Shell parentShell = null;
        if (window != null) {
            parentShell = window.getShell();
        }
        FileDialog fd = new FileDialog(parentShell, 8192);
        fd.setText("Select Output");
        fd.setFilterExtensions(new String[]{"*.txt", "*.csv", "*.*"});
        fd.setFilterNames(new String[]{"Tab-Separated Values (*.txt)", "Comma-Separated Values (*.csv)", "All Files (*.*)"});
        if (lastReportPath != null) {
            fd.setFilterPath(lastReportPath);
        }
        fd.setFileName(fileName);
        String path = fd.open();
        if (path != null) {
            prefs.put(PROP_LAST_PATH, path);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                ExceptionUtils.logError((Throwable)e);
            }
        } else {
            return;
        }
        String _cs = null;
        switch (fd.getFilterIndex()) {
            case 1: {
                _cs = ";";
                if (path.endsWith(".csv")) break;
                path = String.valueOf(path) + ".csv";
                break;
            }
            case 0: {
                if (!path.endsWith(".txt")) {
                    path = String.valueOf(path) + ".txt";
                }
            }
            default: {
                _cs = "\t";
            }
        }
        final String columnSeparator = _cs;
        final File out = new File(path);
        System.out.println("out: " + out);
        try {
            window.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            new EventExporter().exportCsv(monitor, out, columnSeparator);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof FileNotFoundException) {
                ShowError.showError((String)"Export Failed", (String)("Failed to write " + t.getMessage()), null);
            } else {
                ExceptionUtils.logAndShowError((Throwable)t);
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

