/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;

public class EventWriteData {
    public VirtualGraph vg;
    public Layer0 L0;
    public Resource eventLog;
    public Resource targetSlice;
    public String sliceName;
    public int counter;
    public Resource counterResource;
    public Resource firstSliceResource;
    public Map<String, Resource> slices;
    public int targetPos;
    public int targetSliceNumber;

    public EventWriteData(ReadGraph graph, Resource eventLog, VirtualGraph vg) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        this.vg = vg;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.eventLog = eventLog;
        this.counterResource = graph.getSingleObject(eventLog, EVENT.HasModificationCounter);
        this.counter = (Integer)graph.getValue(this.counterResource, (Binding)Bindings.INTEGER);
        int sliceNumber = this.counter / 64;
        this.targetSlice = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)eventLog, (String)("" + sliceNumber));
        this.sliceName = this.targetSlice != null ? "" + sliceNumber : "";
        this.slices = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(eventLog));
    }

    public void prepareToWrite(WriteOnlyGraph graph) throws DatabaseException {
        this.targetPos = this.counter % 64;
        this.targetSliceNumber = this.counter / 64;
        if (this.targetPos == 0 && !this.sliceName.equals("" + this.targetSliceNumber)) {
            Layer0 L0 = (Layer0)graph.getService(Layer0.class);
            EventResource EVENT = (EventResource)graph.getService(EventResource.class);
            this.targetSlice = graph.newResource();
            graph.claim(this.targetSlice, L0.InstanceOf, null, EVENT.EventSlice);
            graph.addLiteral(this.targetSlice, L0.HasName, L0.NameOf, L0.String, (Object)("" + this.targetSliceNumber), (Binding)Bindings.STRING);
            graph.claim(this.targetSlice, L0.PartOf, L0.ConsistsOf, this.eventLog);
            this.slices.put("" + this.targetSliceNumber, this.targetSlice);
            this.sliceName = "" + this.targetSliceNumber;
        }
    }

    public void written() {
        ++this.counter;
    }

    public void commit(WriteOnlyGraph graph) throws DatabaseException {
        graph.claimValue(this.counterResource, (Object)this.counter, (Binding)Bindings.INTEGER);
        int toRemove = Math.max(this.slices.size() - 17, 0);
        if (toRemove > 0) {
            ArrayList<String> keys = new ArrayList<String>(this.slices.keySet());
            Collections.sort(keys, AlphanumComparator.COMPARATOR);
            int i = 0;
            while (i < toRemove) {
                graph.deny(this.eventLog, this.L0.ConsistsOf, this.L0.PartOf, this.slices.get(keys.get(i)), this.vg);
                ++i;
            }
        }
    }
}

