/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.event.writer;

import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * An interface used for queueing to-be-written events in {@link EventWriterJob}.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see EventWriterJob
 */
public interface EventWriteTask {

    /**
     * @param graph
     * @param eventProducer
     * @return the written event
     * @throws DatabaseException
     */
    Resource write(WriteOnlyGraph graph, Resource slice, int number) throws DatabaseException;

}